/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.repackaged.picocontainer.monitors;

import com.pushtechnology.repackaged.picocontainer.Behavior;
import com.pushtechnology.repackaged.picocontainer.ComponentAdapter;
import com.pushtechnology.repackaged.picocontainer.ComponentMonitor;
import com.pushtechnology.repackaged.picocontainer.Injector;
import com.pushtechnology.repackaged.picocontainer.MutablePicoContainer;
import com.pushtechnology.repackaged.picocontainer.PicoContainer;
import com.pushtechnology.repackaged.picocontainer.monitors.ComponentMonitorHelper;
import com.pushtechnology.repackaged.picocontainer.monitors.NullComponentMonitor;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleComponentMonitor
implements ComponentMonitor,
Serializable {
    private final transient PrintStream out;
    private final ComponentMonitor delegate;

    public ConsoleComponentMonitor() {
        this(System.out);
    }

    public ConsoleComponentMonitor(OutputStream out) {
        this(out, new NullComponentMonitor());
    }

    public ConsoleComponentMonitor(OutputStream out, ComponentMonitor delegate) {
        this.out = new PrintStream(out);
        this.delegate = delegate;
    }

    @Override
    public <T> Constructor<T> instantiating(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: instantiating {0}", ComponentMonitorHelper.ctorToString(constructor)));
        return this.delegate.instantiating(container, componentAdapter, constructor);
    }

    @Override
    public <T> void instantiated(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor, Object instantiated, Object[] parameters, long duration) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: instantiated {0} [{1} ms], component {2}, injected [{3}]", ComponentMonitorHelper.ctorToString(constructor), duration, instantiated.getClass().getName(), ComponentMonitorHelper.parmsToString(parameters)));
        this.delegate.instantiated(container, componentAdapter, constructor, instantiated, parameters, duration);
    }

    @Override
    public <T> void instantiationFailed(PicoContainer container, ComponentAdapter<T> componentAdapter, Constructor<T> constructor, Exception cause) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: instantiation failed: {0}, reason: {1}", ComponentMonitorHelper.ctorToString(constructor), cause.getMessage()));
        this.delegate.instantiationFailed(container, componentAdapter, constructor, cause);
    }

    @Override
    public Object invoking(PicoContainer container, ComponentAdapter<?> componentAdapter, Member member, Object instance, Object[] args) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: invoking {0} on {1}", ComponentMonitorHelper.memberToString(member), instance));
        return this.delegate.invoking(container, componentAdapter, member, instance, args);
    }

    @Override
    public void invoked(PicoContainer container, ComponentAdapter<?> componentAdapter, Member member, Object instance, long duration, Object[] args, Object retVal) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: invoked {0} on {1} [{2} ms]", ComponentMonitorHelper.methodToString(member), instance, duration));
        this.delegate.invoked(container, componentAdapter, member, instance, duration, args, retVal);
    }

    @Override
    public void invocationFailed(Member member, Object instance, Exception cause) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: invocation failed: {0} on {1}, reason: {2}", ComponentMonitorHelper.memberToString(member), instance, cause.getMessage()));
        this.delegate.invocationFailed(member, instance, cause);
    }

    @Override
    public void lifecycleInvocationFailed(MutablePicoContainer container, ComponentAdapter<?> componentAdapter, Method method, Object instance, RuntimeException cause) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: lifecycle invocation failed: {0} on {1}, reason: {2}", ComponentMonitorHelper.methodToString(method), instance, cause.getMessage()));
        this.delegate.lifecycleInvocationFailed(container, componentAdapter, method, instance, cause);
    }

    @Override
    public Object noComponentFound(MutablePicoContainer container, Object componentKey) {
        this.out.println(ComponentMonitorHelper.format("PicoContainer: No component for key: {0}", componentKey));
        return this.delegate.noComponentFound(container, componentKey);
    }

    @Override
    public Injector newInjector(Injector injector) {
        return this.delegate.newInjector(injector);
    }

    @Override
    public Behavior newBehavior(Behavior behavior) {
        return this.delegate.newBehavior(behavior);
    }
}

