/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.repackaged.picocontainer.adapters;

import com.pushtechnology.repackaged.picocontainer.ComponentAdapter;
import com.pushtechnology.repackaged.picocontainer.ComponentMonitor;
import com.pushtechnology.repackaged.picocontainer.ComponentMonitorStrategy;
import com.pushtechnology.repackaged.picocontainer.PicoCompositionException;
import com.pushtechnology.repackaged.picocontainer.PicoContainer;
import com.pushtechnology.repackaged.picocontainer.PicoVisitor;
import com.pushtechnology.repackaged.picocontainer.injectors.Provider;
import com.pushtechnology.repackaged.picocontainer.injectors.ProviderAdapter;
import com.pushtechnology.repackaged.picocontainer.monitors.AbstractComponentMonitor;
import com.pushtechnology.repackaged.picocontainer.monitors.NullComponentMonitor;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAdapter<T>
implements ComponentAdapter<T>,
ComponentMonitorStrategy,
Serializable {
    private Object componentKey;
    private Class<T> componentImplementation;
    private ComponentMonitor componentMonitor;

    public AbstractAdapter(Object componentKey, Class componentImplementation) {
        this(componentKey, componentImplementation, new AbstractComponentMonitor());
        this.componentMonitor = new NullComponentMonitor();
    }

    public AbstractAdapter(Object componentKey, Class componentImplementation, ComponentMonitor monitor) {
        if (monitor == null) {
            throw new NullPointerException("ComponentMonitor==null");
        }
        this.componentMonitor = monitor;
        if (componentImplementation == null) {
            throw new NullPointerException("componentImplementation");
        }
        this.componentKey = componentKey;
        this.componentImplementation = componentImplementation;
        this.checkTypeCompatibility();
    }

    @Override
    public Object getComponentKey() {
        if (this.componentKey == null) {
            throw new NullPointerException("componentKey");
        }
        return this.componentKey;
    }

    @Override
    public Class<? extends T> getComponentImplementation() {
        return this.componentImplementation;
    }

    protected void checkTypeCompatibility() {
        if (this.componentKey instanceof Class) {
            Class componentType = (Class)this.componentKey;
            if (Provider.class.isAssignableFrom(this.componentImplementation) ? !componentType.isAssignableFrom(ProviderAdapter.getProvideMethod(this.componentImplementation).getReturnType()) : !componentType.isAssignableFrom(this.componentImplementation)) {
                throw this.newCCE(componentType);
            }
        }
    }

    private ClassCastException newCCE(Class<?> componentType) {
        return new ClassCastException(this.componentImplementation.getName() + " is not a " + componentType.getName());
    }

    @Override
    public T getComponentInstance(PicoContainer container) throws PicoCompositionException {
        return this.getComponentInstance(container, null);
    }

    public String toString() {
        return this.getDescriptor() + this.getComponentKey();
    }

    @Override
    public void accept(PicoVisitor visitor) {
        visitor.visitComponentAdapter(this);
    }

    @Override
    public void changeMonitor(ComponentMonitor monitor) {
        this.componentMonitor = monitor;
    }

    @Override
    public ComponentMonitor currentMonitor() {
        return this.componentMonitor;
    }

    @Override
    public final ComponentAdapter<T> getDelegate() {
        return null;
    }

    @Override
    public final <U extends ComponentAdapter> U findAdapterOfType(Class<U> adapterType) {
        if (adapterType.isAssignableFrom(this.getClass())) {
            return (U)this;
        }
        if (this.getDelegate() != null) {
            return this.getDelegate().findAdapterOfType(adapterType);
        }
        return null;
    }
}

