/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.utils.tuple;

import net.jcip.annotations.Immutable;

@Immutable
public final class Pair<F, S>
implements Comparable<Pair<F, S>> {
    private final F first;
    private final S second;

    public static <P, F extends P, Q, S extends Q> Pair<P, Q> of(F first, S second) {
        return new Pair<F, S>(first, second);
    }

    private Pair(F first, S second) {
        this.first = first;
        this.second = second;
    }

    public F getFirst() {
        return this.first;
    }

    public S getSecond() {
        return this.second;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair other = (Pair)o;
        if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
            return false;
        }
        if (this.second == null) {
            return other.second == null;
        }
        return this.second.equals(other.second);
    }

    @Override
    public int compareTo(Pair<F, S> o) {
        int compareFirst = ((Comparable)this.first).compareTo(o.getFirst());
        if (compareFirst != 0) {
            return compareFirst;
        }
        return ((Comparable)this.second).compareTo(o.getSecond());
    }

    public String toString() {
        return String.format("[%s,%s]", this.first, this.second);
    }
}

