/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.utils.math;

public final class DiffusionMath {
    private DiffusionMath() {
    }

    public static int findNextPowerOfTwo(int value) {
        if (value < 0 || value > 0x40000000) {
            throw new IllegalArgumentException(Integer.toString(value));
        }
        return 1 << DiffusionMath.highestBit(value - 1);
    }

    public static long findNextPowerOfTwo(long value) {
        if (value < 0L || value > 0x4000000000000000L) {
            throw new IllegalArgumentException(Long.toString(value));
        }
        return 1L << DiffusionMath.highestBit(value - 1L);
    }

    public static int highestBit(int value) {
        return 32 - Integer.numberOfLeadingZeros(value);
    }

    public static int highestBit(long value) {
        return 64 - Long.numberOfLeadingZeros(value);
    }

    public static int approximateSquareRoot(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException(Long.toString(value));
        }
        if (value == 0L) {
            return 0;
        }
        return 1 << DiffusionMath.highestBit(value) / 2;
    }

    public static int approximateCubeRoot(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException(Long.toString(value));
        }
        if (value == 0L) {
            return 0;
        }
        int h = DiffusionMath.highestBit(value);
        return 1 << h / 3;
    }
}

