/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.utils.io;

import com.pushtechnology.diffusion.exceptions.DiffusionInterruptedException;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private IOUtils() {
    }

    public static void closeQuietly(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException ignore) {
                DiffusionInterruptedException.ioException(ignore);
            }
        }
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.copy(input, output);
        return output.toByteArray();
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer, 0, buffer.length)) != -1) {
            out.write(buffer, 0, bytesRead);
            out.flush();
        }
    }

    public static byte[] readByteArray(InputStream in, int length) throws IOException {
        if (length < 0) {
            throw new IOException("Negative byte array length");
        }
        byte[] bytes = new byte[length];
        IOUtils.readByteArray(in, bytes, length);
        return bytes;
    }

    public static void readByteArray(InputStream in, byte[] bytes, int length) throws IOException {
        int r;
        if (bytes.length < length) {
            throw new IOException("bytes.length < length");
        }
        for (int o = 0; o < length; o += r) {
            r = in.read(bytes, o, length - o);
            if (r != -1) continue;
            throw new IOException("Stream exhausted");
        }
    }

    public static void writeShortBigEndian(OutputStream out, short s) throws IOException {
        out.write(s >> 8);
        out.write(s >> 0);
    }

    public static void writeIntBigEndian(OutputStream out, int i) throws IOException {
        out.write(i >> 24);
        out.write(i >> 16);
        out.write(i >> 8);
        out.write(i >> 0);
    }

    public static void writeLongBigEndian(OutputStream out, long l) throws IOException {
        out.write((int)(l >> 56 & 0xFFL));
        out.write((int)(l >> 48 & 0xFFL));
        out.write((int)(l >> 40 & 0xFFL));
        out.write((int)(l >> 32 & 0xFFL));
        out.write((int)(l >> 24 & 0xFFL));
        out.write((int)(l >> 16 & 0xFFL));
        out.write((int)(l >> 8 & 0xFFL));
        out.write((int)(l >> 0 & 0xFFL));
    }
}

