/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.utils.bytebuffer;

import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.util.concurrent.threads.FastThreadLocal;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import com.pushtechnology.diffusion.utils.bytebuffer.ByteBufferPoolImpl;
import com.pushtechnology.diffusion.utils.bytebuffer.ManagedByteBufferPool;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
public class ThreadSafeBufferPool
implements ManagedByteBufferPool {
    private static final Logger LOG = I18nLogger.getLogger(ThreadSafeBufferPool.class);
    protected static final int PER_THREAD_MAXIMUM_CAPACITY = ConfigurationUtils.getIntegerSystemProperty("diffusion.buffers.thread.maximum_size", 0x800000);
    protected static final int SHARED_MAXIMUM = ConfigurationUtils.getIntegerSystemProperty("diffusion.buffers.shared.maximum", 128);
    protected static final boolean ALLOCATION_TRACING = ConfigurationUtils.getBooleanSystemProperty("diffusion.buffers.server.allocation_tracing");
    private final FastThreadLocal<ByteBufferPoolImpl> threadLocalPools;
    @GuardedBy(value="sharedPool")
    private final ByteBufferPoolImpl sharedPool;
    @GuardedBy(value="sharedPool")
    private final Set<ByteBufferPoolImpl> allThreadLocalPools = Collections.newSetFromMap(new WeakHashMap());
    @GuardedBy(value="sharedPool")
    private final Set<ManagedByteBufferPool.Statistics> collectedStats = new HashSet<ManagedByteBufferPool.Statistics>();
    private final String poolName;

    public ThreadSafeBufferPool(int perThreadInitial, int perThreadMaximum, int perThreadMaximumBufferCapacity, int sharedMaximum, int minimumBufferCapacity, String name) {
        this.poolName = name;
        this.sharedPool = new ByteBufferPoolImpl(ByteBufferPoolImpl.BUFFER_POOL_DEFAULTS.maximumPerCapacity(sharedMaximum).minimumCapacity(minimumBufferCapacity).name(name + "[shared]"));
        this.threadLocalPools = FastThreadLocal.withInitial(() -> new AccountingSafeByteBufferPoolImpl(ByteBufferPoolImpl.BUFFER_POOL_DEFAULTS.initialPerCapacity(perThreadInitial).maximumPerCapacity(perThreadMaximum).maximumCapacity(perThreadMaximumBufferCapacity).minimumCapacity(minimumBufferCapacity).name(name + "[" + Thread.currentThread().getName() + "]")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer provide(int capacity) {
        ByteBufferPoolImpl sp;
        ByteBuffer fromThread;
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}.provide({})", (Object)this.poolName, (Object)capacity);
        }
        if ((fromThread = this.threadLocalPools.get().poll(capacity)) != null) {
            return fromThread;
        }
        ByteBufferPoolImpl byteBufferPoolImpl = sp = this.sharedPool;
        synchronized (byteBufferPoolImpl) {
            return sp.provide(capacity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(ByteBuffer buffer) {
        LOG.trace("{}.release({})", (Object)this.poolName, (Object)buffer);
        if (buffer.isDirect() && !this.threadLocalPools.get().offer(buffer)) {
            ByteBufferPoolImpl sp;
            ByteBufferPoolImpl byteBufferPoolImpl = sp = this.sharedPool;
            synchronized (byteBufferPoolImpl) {
                sp.release(buffer);
            }
        }
    }

    FastThreadLocal<ByteBufferPoolImpl> getThreadLocalPools() {
        return this.threadLocalPools;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        ByteBufferPoolImpl sp;
        ByteBufferPoolImpl byteBufferPoolImpl = sp = this.sharedPool;
        synchronized (byteBufferPoolImpl) {
            this.traceStatistics("beforeDestroy");
            for (ByteBufferPoolImpl pool : this.allThreadLocalPools) {
                pool.destroy();
            }
            sp.destroy();
            this.traceStatistics("afterDestroy");
        }
    }

    private void traceStatistics(String when) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}({}), globals={}]", when, this, ByteBufferPoolImpl.GLOBAL_ACCOUNT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedByteBufferPool.Statistics statistics() {
        ByteBufferPoolImpl sp;
        ByteBufferPoolImpl byteBufferPoolImpl = sp = this.sharedPool;
        synchronized (byteBufferPoolImpl) {
            ManagedByteBufferPool.Statistics stats = sp.statistics();
            for (ByteBufferPoolImpl pool : this.allThreadLocalPools) {
                stats = stats.add(pool.statistics());
            }
            for (ManagedByteBufferPool.Statistics collected : this.collectedStats) {
                stats = stats.add(collected);
            }
            return stats;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ByteBufferPoolImpl sp;
        StringBuilder sb = new StringBuilder(39);
        ByteBufferPoolImpl byteBufferPoolImpl = sp = this.sharedPool;
        synchronized (byteBufferPoolImpl) {
            sb.append(this.poolName).append('[').append(sp.statistics()).append(", ").append(this.allThreadLocalPools.size()).append(" threads: ");
            for (ByteBufferPoolImpl pool : this.allThreadLocalPools) {
                sb.append('[').append(pool.statistics()).append(']');
            }
            sb.append(", ").append(this.collectedStats.size()).append(" collected threads: ");
            for (ManagedByteBufferPool.Statistics collected : this.collectedStats) {
                sb.append('[').append(collected).append(']');
            }
        }
        return sb.toString();
    }

    private final class AccountingSafeByteBufferPoolImpl
    extends ByteBufferPoolImpl {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AccountingSafeByteBufferPoolImpl(ByteBufferPoolImpl.Parameters parameters) {
            super(parameters);
            ByteBufferPoolImpl byteBufferPoolImpl = ThreadSafeBufferPool.this.sharedPool;
            synchronized (byteBufferPoolImpl) {
                ThreadSafeBufferPool.this.allThreadLocalPools.add(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void finalize() throws Throwable {
            ByteBufferPoolImpl byteBufferPoolImpl = ThreadSafeBufferPool.this.sharedPool;
            synchronized (byteBufferPoolImpl) {
                ThreadSafeBufferPool.this.collectedStats.add(super.statistics());
            }
            super.finalize();
        }
    }
}

