/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.utils.bytebuffer;

import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import com.pushtechnology.diffusion.utils.bytebuffer.ThreadSafeBufferPool;
import com.pushtechnology.repackaged.picocontainer.Disposable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ClientByteBufferPoolImpl
extends ThreadSafeBufferPool
implements Disposable {
    private static final int PER_THREAD_INITIAL = ConfigurationUtils.getIntegerSystemProperty("diffusion.buffers.thread.initial", 1);
    private static final int PER_THREAD_MAXIMUM = ConfigurationUtils.getIntegerSystemProperty("diffusion.buffers.thread.maximum", 1);
    private static final Logger LOG = LoggerFactory.getLogger(ClientByteBufferPoolImpl.class);
    private final Map<ByteBuffer, Throwable> stacks = ALLOCATION_TRACING ? Collections.synchronizedMap(new IdentityHashMap()) : null;

    public ClientByteBufferPoolImpl() {
        super(PER_THREAD_INITIAL, PER_THREAD_MAXIMUM, PER_THREAD_MAXIMUM_CAPACITY, SHARED_MAXIMUM, 0, "ClientBufferPool");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (ALLOCATION_TRACING) {
            Map<ByteBuffer, Throwable> map = this.stacks;
            synchronized (map) {
                for (Throwable e : this.stacks.values()) {
                    LOG.warn("Unreleased allocation", e);
                }
            }
        }
        this.destroy();
    }

    @Override
    public ByteBuffer provide(int capacity) {
        ByteBuffer buff = super.provide(capacity);
        if (ALLOCATION_TRACING) {
            this.stacks.put(buff, new Throwable().fillInStackTrace());
        }
        return buff;
    }

    @Override
    public void release(ByteBuffer buffer) {
        if (ALLOCATION_TRACING && this.stacks.remove(buffer) == null && buffer.isDirect()) {
            LOG.warn("Could not find allocation for {}", (Object)buffer);
        }
        super.release(buffer);
    }
}

