/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.utils;

import java.io.IOException;
import java.io.OutputStream;

public final class FastEncoderCore {
    static final byte REPLACEMENT = 63;

    private FastEncoderCore() {
    }

    public static int parseSurrogateSequence(char c, String s, int ip, int il) {
        if (il - ip < 2 || !Character.isHighSurrogate(c)) {
            return -1;
        }
        char d = s.charAt(ip + 1);
        if (!Character.isLowSurrogate(d)) {
            return -1;
        }
        return Character.toCodePoint(c, d);
    }

    static int utf8Length(String s) {
        int sl = s.length();
        for (int sp = 0; sp < sl; ++sp) {
            char c = s.charAt(sp);
            if (c < '\u0080') continue;
            return sp + FastEncoderCore.utf8LengthNonAscii(s, sp, sl);
        }
        return sl;
    }

    private static int utf8LengthNonAscii(String s, int sourceStart, int sl) {
        int dp = 0;
        for (int sp = sourceStart; sp < sl; ++sp) {
            char c = s.charAt(sp);
            if (c < '\u0080') {
                ++dp;
                continue;
            }
            if (c < '\u0800') {
                dp += 2;
                continue;
            }
            if (Character.isSurrogate(c)) {
                if (sl - sp < 2 || !Character.isHighSurrogate(c) || !Character.isLowSurrogate(s.charAt(sp + 1))) {
                    ++dp;
                    continue;
                }
                dp += 4;
                ++sp;
                continue;
            }
            dp += 3;
        }
        return dp;
    }

    static void utf8Encode(String s, OutputStream out) throws IOException {
        int sl = s.length();
        for (int i = 0; i < sl; ++i) {
            char c = s.charAt(i);
            if (c >= '\u0080') {
                FastEncoderCore.utf8EncodeNonAscii(s, i, sl, out);
                return;
            }
            out.write((byte)c);
        }
    }

    private static void utf8EncodeNonAscii(String s, int sp, int charsLength, OutputStream out) throws IOException {
        int i = sp;
        do {
            char c;
            if ((c = s.charAt(i)) < '\u0080') {
                out.write((byte)c);
                continue;
            }
            if (c < '\u0800') {
                out.write((byte)(0xC0 | c >> 6));
                out.write((byte)(0x80 | c & 0x3F));
                continue;
            }
            if (Character.isSurrogate(c)) {
                int uc = FastEncoderCore.parseSurrogateSequence(c, s, i, charsLength);
                if (uc < 0) {
                    out.write(63);
                    continue;
                }
                out.write((byte)(0xF0 | uc >> 18));
                out.write((byte)(0x80 | uc >> 12 & 0x3F));
                out.write((byte)(0x80 | uc >> 6 & 0x3F));
                out.write((byte)(0x80 | uc & 0x3F));
                ++i;
                continue;
            }
            out.write((byte)(0xE0 | c >> 12));
            out.write((byte)(0x80 | c >> 6 & 0x3F));
            out.write((byte)(0x80 | c & 0x3F));
        } while (++i < charsLength);
    }

    static void asciiEncode(String s, OutputStream out) throws IOException {
        int sl = s.length();
        for (int i = 0; i < sl; ++i) {
            int b;
            char c = s.charAt(i);
            if (c < '\u0080') {
                b = c;
            } else {
                if (i + 1 < sl && Character.isHighSurrogate(c) && Character.isLowSurrogate(s.charAt(i + 1))) {
                    ++i;
                }
                b = 63;
            }
            out.write(b);
        }
    }
}

