/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.utils;

import com.pushtechnology.diffusion.utils.FastEncoderCore;
import com.pushtechnology.diffusion.utils.unsafe.UnsafeAccess;
import com.pushtechnology.diffusion.utils.unsafe.UnsafeDirectByteBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public final class FastEncoder {
    private static final int ARRAY_BASE_OFFSET = UnsafeAccess.UNSAFE.arrayBaseOffset(byte[].class);

    private FastEncoder() {
    }

    public static void utf8Encode(String s, ByteBuffer buffer) {
        byte[] destination;
        long address;
        if (buffer.hasArray()) {
            address = buffer.arrayOffset() + ARRAY_BASE_OFFSET;
            destination = buffer.array();
        } else {
            address = UnsafeDirectByteBuffer.getAddress(buffer);
            destination = null;
        }
        long lastDp = FastEncoder.utf8Encode(s, destination, address + (long)buffer.position(), address + (long)buffer.limit());
        buffer.position((int)(lastDp - address));
    }

    private static long utf8Encode(String source, byte[] destination, long initialOffset, long offsetLimit) {
        long dp;
        long asciiOffsetLimit = initialOffset + (long)source.length();
        if (asciiOffsetLimit > offsetLimit) {
            throw new BufferOverflowException();
        }
        int sp = 0;
        for (dp = initialOffset; dp < asciiOffsetLimit; ++dp) {
            char c = source.charAt(sp);
            if (c >= '\u0080') {
                return FastEncoder.utf8EncodeNonAscii(source, sp, destination, dp, offsetLimit);
            }
            UnsafeAccess.UNSAFE.putByte(destination, dp, (byte)c);
            ++sp;
        }
        return dp;
    }

    private static long utf8EncodeNonAscii(String source, int sourceStart, byte[] destination, long initialOffset, long offsetLimit) {
        int sp = sourceStart;
        int sl = source.length();
        long dp = initialOffset;
        do {
            char c;
            if ((c = source.charAt(sp)) < '\u0080') {
                if (dp + 1L > offsetLimit) {
                    throw new BufferOverflowException();
                }
                UnsafeAccess.UNSAFE.putByte(destination, dp++, (byte)c);
                continue;
            }
            if (c < '\u0800') {
                if (dp + 2L > offsetLimit) {
                    throw new BufferOverflowException();
                }
                UnsafeAccess.UNSAFE.putByte(destination, dp++, (byte)(0xC0 | c >> 6));
                UnsafeAccess.UNSAFE.putByte(destination, dp++, (byte)(0x80 | c & 0x3F));
                continue;
            }
            if (Character.isSurrogate(c)) {
                if (dp + 4L > offsetLimit) {
                    throw new BufferOverflowException();
                }
                int uc = FastEncoderCore.parseSurrogateSequence(c, source, sp, sl);
                if (uc < 0) {
                    UnsafeAccess.UNSAFE.putByte(destination, dp++, (byte)63);
                    continue;
                }
                UnsafeAccess.UNSAFE.putByte(destination, dp++, (byte)(0xF0 | uc >> 18));
                UnsafeAccess.UNSAFE.putByte(destination, dp++, (byte)(0x80 | uc >> 12 & 0x3F));
                UnsafeAccess.UNSAFE.putByte(destination, dp++, (byte)(0x80 | uc >> 6 & 0x3F));
                UnsafeAccess.UNSAFE.putByte(destination, dp++, (byte)(0x80 | uc & 0x3F));
                ++sp;
                continue;
            }
            if (dp + 3L > offsetLimit) {
                throw new BufferOverflowException();
            }
            UnsafeAccess.UNSAFE.putByte(destination, dp++, (byte)(0xE0 | c >> 12));
            UnsafeAccess.UNSAFE.putByte(destination, dp++, (byte)(0x80 | c >> 6 & 0x3F));
            UnsafeAccess.UNSAFE.putByte(destination, dp++, (byte)(0x80 | c & 0x3F));
        } while (++sp < sl);
        return dp;
    }

    public static int utf8Length(String s) {
        return FastEncoderCore.utf8Length(s);
    }

    public static void utf8Encode(String s, OutputStream out) throws IOException {
        FastEncoderCore.utf8Encode(s, out);
    }

    public static void asciiEncode(String s, ByteBuffer buffer) {
        byte[] destination;
        long address;
        if (buffer.hasArray()) {
            address = buffer.arrayOffset() + ARRAY_BASE_OFFSET;
            destination = buffer.array();
        } else {
            address = UnsafeDirectByteBuffer.getAddress(buffer);
            destination = null;
        }
        int sl = s.length();
        if (sl > buffer.remaining()) {
            throw new BufferOverflowException();
        }
        int dp = buffer.position();
        int sp = 0;
        while (sp < sl) {
            byte b;
            char c = s.charAt(sp);
            if (c < '\u0080') {
                b = (byte)c;
            } else {
                if (sp + 1 < sl && Character.isHighSurrogate(c) && Character.isLowSurrogate(s.charAt(sp + 1))) {
                    ++sp;
                }
                b = 63;
            }
            UnsafeAccess.UNSAFE.putByte(destination, address + (long)dp, b);
            ++sp;
            ++dp;
        }
        buffer.position(dp);
    }

    public static void asciiEncode(String s, OutputStream out) throws IOException {
        FastEncoderCore.asciiEncode(s, out);
    }
}

