/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.util.concurrent.threads;

import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;

public final class LoggingScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private static final Logger LOG = I18nLogger.getLogger(LoggingScheduledThreadPoolExecutor.class);
    private final String logContext;

    public LoggingScheduledThreadPoolExecutor(String logContext, int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
        this.logContext = logContext;
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        assert (t == null);
        FutureTask f = (FutureTask)r;
        try {
            if (f.isDone()) {
                f.get();
            }
        }
        catch (ExecutionException e) {
            if (LOG.isErrorEnabled()) {
                Throwable cause = e.getCause();
                LOG.error("THREADS_EXECUTOR_TASK_EXCEPTION", (Object)this.logContext, (Object)cause);
            }
        }
        catch (CancellationException e) {
            LOG.trace("{}: {} was cancelled", (Object)this.logContext, (Object)f);
        }
        catch (InterruptedException e) {
            LOG.debug("{}: {} was interrupted while processing", this.logContext, f, e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public String toString() {
        return this.logContext + ":" + super.toString();
    }
}

