/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.usage.snapshot;

import com.pushtechnology.diffusion.usage.UsageType;
import com.pushtechnology.diffusion.usage.snapshot.SampleSnapshot;
import com.pushtechnology.diffusion.usage.snapshot.SampleSnapshotType;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class UsageSnapshot {
    private final String licenceUuid;
    private final String instanceIdentifier;
    private final long instanceStartTime;
    private final String serverName;
    private final UsageType usageType;
    private final SampleSnapshot sampleSnapshot;
    private final byte version;

    public UsageSnapshot(String licenceUuid, String instanceIdentifier, long instanceStartTime, String serverName, UsageType usageType, SampleSnapshot sampleSnapshot, byte version) {
        this.licenceUuid = licenceUuid;
        this.instanceIdentifier = instanceIdentifier;
        this.instanceStartTime = instanceStartTime;
        this.serverName = serverName;
        this.usageType = usageType;
        this.sampleSnapshot = sampleSnapshot;
        this.version = version;
    }

    public String getLicenceUuid() {
        return this.licenceUuid;
    }

    public String getInstanceIdentifier() {
        return this.instanceIdentifier;
    }

    public long getInstanceStartTime() {
        return this.instanceStartTime;
    }

    public String getServerName() {
        return this.serverName;
    }

    public UsageType getUsageType() {
        return this.usageType;
    }

    public SampleSnapshot getSampleSnapshot() {
        return this.sampleSnapshot;
    }

    public boolean isShutDown() {
        return this.sampleSnapshot.getSampleSnapshotType() == SampleSnapshotType.SNAPSHOT_SHUTDOWN;
    }

    public byte getVersion() {
        return this.version;
    }

    public String toString() {
        return "UsageSnapshot{licenceUuid='" + this.licenceUuid + "', instanceIdentifier='" + this.instanceIdentifier + "', instanceStartTime=" + this.instanceStartTime + ", serverName='" + this.serverName + "', usageType='" + String.valueOf((Object)this.usageType) + "', sampleSnapshot=" + String.valueOf(this.sampleSnapshot) + ", version=" + this.version + "}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UsageSnapshot)) {
            return false;
        }
        UsageSnapshot otherUsageSnapshot = (UsageSnapshot)other;
        return this.instanceStartTime == otherUsageSnapshot.instanceStartTime && Objects.equals(this.licenceUuid, otherUsageSnapshot.licenceUuid) && Objects.equals(this.instanceIdentifier, otherUsageSnapshot.instanceIdentifier) && Objects.equals(this.serverName, otherUsageSnapshot.serverName) && this.usageType == otherUsageSnapshot.usageType && Objects.equals(this.sampleSnapshot, otherUsageSnapshot.sampleSnapshot) && this.version == otherUsageSnapshot.version;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.licenceUuid, this.instanceIdentifier, this.instanceStartTime, this.serverName, this.usageType, this.sampleSnapshot, this.version});
    }
}

