/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.types;

import com.pushtechnology.diffusion.client.types.ErrorReport;
import net.jcip.annotations.Immutable;

@Immutable
public final class ErrorReportImpl
implements ErrorReport {
    private static final long serialVersionUID = 813730397476759431L;
    private final String message;
    private final int line;
    private final int column;

    public ErrorReportImpl(String message, int line, int column) {
        this.message = message;
        this.line = line;
        this.column = column;
    }

    public ErrorReportImpl(String message) {
        this(message, 0, 0);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    public int hashCode() {
        int prime = 31;
        int result = this.column;
        result = 31 * result + this.line;
        result = 31 * result + this.message.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorReportImpl other = (ErrorReportImpl)o;
        return this.column == other.column && this.line == other.line && this.message.equals(other.message);
    }

    public String toString() {
        return String.format("%s at [%d:%d]", this.message, this.line, this.column);
    }
}

