/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.topics.views;

import com.pushtechnology.diffusion.client.features.control.topics.views.TopicView;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.topics.views.GetTopicViewResult;
import com.pushtechnology.diffusion.topics.views.TopicViewImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;

@CommandSerialiser(spec="get-topic-view-result", valueType=GetTopicViewResult.class)
public final class GetTopicViewResultSerialiser
extends AbstractSerialiser<GetTopicViewResult> {
    @Override
    protected GetTopicViewResult readUnchecked(InputStream in) throws IOException {
        byte option = EncodedDataCodec.readByte(in);
        if (option == 1) {
            return new GetTopicViewResult(this.readView(in));
        }
        if (option == 0) {
            return GetTopicViewResult.NO_SUCH_VIEW;
        }
        throw new IOException("Invalid option byte " + option);
    }

    private TopicView readView(InputStream in) throws IOException {
        String name = EncodedDataCodec.readString(in);
        String specification = EncodedDataCodec.readString(in);
        HashSet<String> roles = new HashSet<String>(GetTopicViewResultSerialiser.readStrings(in));
        return new TopicViewImpl(name, specification, roles);
    }

    @Override
    public void write(OutputStream out, GetTopicViewResult result) throws IOException {
        if (result == GetTopicViewResult.NO_SUCH_VIEW) {
            EncodedDataCodec.writeByte(out, (byte)0);
        } else {
            TopicView view = result.getView();
            EncodedDataCodec.writeByte(out, (byte)1);
            EncodedDataCodec.writeString(out, view.getName());
            EncodedDataCodec.writeString(out, view.getSpecification());
            GetTopicViewResultSerialiser.writeStrings(out, view.getRoles());
        }
    }
}

