/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.topics.views;

import com.pushtechnology.diffusion.client.features.control.topics.views.TopicView;
import com.pushtechnology.diffusion.client.types.ErrorReport;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.topics.views.CreateTopicViewResult;
import com.pushtechnology.diffusion.topics.views.TopicViewImpl;
import com.pushtechnology.diffusion.types.ErrorReportSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;

@CommandSerialiser(spec="create-topic-view-result", valueType=CreateTopicViewResult.class)
public final class CreateTopicViewResultSerialiser
extends AbstractSerialiser<CreateTopicViewResult> {
    private final ErrorReportSerialiser errorReportSerialiser;

    public CreateTopicViewResultSerialiser(ErrorReportSerialiser errorReportSerialiser) {
        this.errorReportSerialiser = errorReportSerialiser;
    }

    @Override
    protected CreateTopicViewResult readUnchecked(InputStream in) throws IOException {
        List<ErrorReport> errors = CreateTopicViewResultSerialiser.readList(in, this.errorReportSerialiser);
        TopicView topicView = errors.isEmpty() ? CreateTopicViewResultSerialiser.readView(in) : null;
        return new CreateTopicViewResult(topicView, errors);
    }

    @Override
    public void write(OutputStream out, CreateTopicViewResult value) throws IOException {
        CreateTopicViewResultSerialiser.writeCollection(out, this.errorReportSerialiser, value.getErrors());
        if (value.getErrors().isEmpty()) {
            CreateTopicViewResultSerialiser.writeView(out, value.getView());
        }
    }

    private static TopicView readView(InputStream in) throws IOException {
        String name = EncodedDataCodec.readString(in);
        String specification = EncodedDataCodec.readString(in);
        HashSet<String> roles = new HashSet<String>(CreateTopicViewResultSerialiser.readStrings(in));
        return new TopicViewImpl(name, specification, roles);
    }

    private static void writeView(OutputStream out, TopicView view) throws IOException {
        EncodedDataCodec.writeString(out, view.getName());
        EncodedDataCodec.writeString(out, view.getSpecification());
        CreateTopicViewResultSerialiser.writeStrings(out, view.getRoles());
    }
}

