/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.topics.update.update.stream;

import com.pushtechnology.diffusion.journal.Journable;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public final class UpdateStreamId
implements Journable {
    private final int topicId;
    private final int instanceId;
    private final int partitionId;
    private final int generationId;
    private final boolean clustered;

    public UpdateStreamId(int topicId, int instanceId) {
        this.topicId = topicId;
        this.instanceId = instanceId;
        this.partitionId = 0;
        this.generationId = 0;
        this.clustered = false;
    }

    public UpdateStreamId(int topicId, int instanceId, int partitionId, int generationId) {
        this.topicId = topicId;
        this.instanceId = instanceId;
        this.partitionId = partitionId;
        this.generationId = generationId;
        this.clustered = true;
    }

    public int getTopicId() {
        return this.topicId;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public int getGenerationId() {
        return this.generationId;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateStreamId streamId = (UpdateStreamId)o;
        return this.getTopicId() == streamId.getTopicId() && this.getInstanceId() == streamId.getInstanceId() && this.partitionId == streamId.partitionId && this.generationId == streamId.generationId;
    }

    public int hashCode() {
        int result = this.topicId;
        result = 31 * result + this.instanceId;
        result = 31 * result + this.generationId;
        result = 31 * result + this.partitionId;
        return result;
    }

    public String toString() {
        if (this.clustered) {
            return "UpdateStreamId[topicId=" + this.topicId + ", instanceId=" + this.instanceId + ", partitionId=" + this.partitionId + ", generationId=" + this.generationId + "]";
        }
        return "UpdateStreamId[topicId=" + this.topicId + ", instanceId=" + this.instanceId + "]";
    }

    @Override
    public Map<String, Object> getJournableContext() {
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>(4);
        context.put("topic", this.topicId);
        context.put("instance", this.instanceId);
        if (this.clustered) {
            context.put("partition", this.partitionId);
            context.put("generation", this.generationId);
        }
        return context;
    }
}

