/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.topics.tree;

public final class TopicPathUtilities {
    public static final char PATH_SEPARATOR = '/';
    public static final String PATH_SEPARATOR_STRING = Character.toString('/');

    private TopicPathUtilities() {
    }

    public static String canonicalisePath(String topicPath) {
        int l = topicPath.length();
        int s = l > 0 && topicPath.charAt(0) == '/' ? 1 : 0;
        int e = l > 1 && topicPath.charAt(l - 1) == '/' ? 1 : 0;
        return topicPath.substring(s, l - e);
    }

    public static boolean isValidPath(String topicPath) {
        return !topicPath.isEmpty() && topicPath.charAt(0) != '/' && topicPath.charAt(topicPath.length() - 1) != '/' && !topicPath.contains("//");
    }

    public static boolean startsWith(String path, String prefix) {
        for (int i = prefix.length() - 1; i >= 0; --i) {
            if (path.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static int countParts(String path) {
        return TopicPathUtilities.countParts(path, 0);
    }

    public static int countParts(String path, int start) {
        if (start >= path.length()) {
            return 0;
        }
        int count = 1;
        for (int i = start; i < path.length(); ++i) {
            if (path.codePointAt(i) != 47) continue;
            ++count;
        }
        return count;
    }
}

