/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.topics.selectors;

import com.pushtechnology.diffusion.topics.selectors.AbstractNonSetTopicSelector;
import com.pushtechnology.diffusion.topics.selectors.AbstractTopicSelectorParserImpl;
import com.pushtechnology.diffusion.topics.selectors.DescendantQualifier;
import com.pushtechnology.diffusion.topics.selectors.SelectorComponents;
import com.pushtechnology.diffusion.topics.tree.TopicPathUtilities;
import net.jcip.annotations.Immutable;

@Immutable
class SplitPathPatternSelector
extends AbstractNonSetTopicSelector {
    private final AbstractTopicSelectorParserImpl.StringPredicate[] predicates;

    SplitPathPatternSelector(AbstractTopicSelectorParserImpl.StringPredicate[] predicates, String[] literals, SelectorComponents components) {
        super(components);
        this.predicates = predicates;
    }

    @Override
    public final boolean confirmSelects(String topicPath, DescendantQualifier dq) {
        int s = this.suffixStart();
        int parts = TopicPathUtilities.countParts(topicPath, s);
        switch (dq) {
            case MATCH: {
                if (parts == this.predicates().length) break;
                return false;
            }
            case DESCENDANTS_OF_MATCH: {
                if (parts > this.predicates().length) break;
                return false;
            }
            default: {
                if (parts >= this.predicates().length) break;
                return false;
            }
        }
        for (AbstractTopicSelectorParserImpl.StringPredicate p : this.predicates()) {
            int e = topicPath.indexOf(47, s);
            if (e == -1) {
                return p.test(topicPath, s, topicPath.length());
            }
            if (!p.test(topicPath, s, e)) {
                return false;
            }
            s = e + 1;
        }
        return true;
    }

    private int suffixStart() {
        String pathPrefix = this.getPathPrefix();
        return pathPrefix.isEmpty() ? 0 : pathPrefix.length() + 1;
    }

    protected final AbstractTopicSelectorParserImpl.StringPredicate[] predicates() {
        return this.predicates;
    }
}

