/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.topics.selectors;

import com.pushtechnology.diffusion.client.topics.TopicPathSelector;
import com.pushtechnology.diffusion.topics.selectors.AbstractNonSetTopicSelector;
import com.pushtechnology.diffusion.topics.selectors.DescendantQualifier;
import com.pushtechnology.diffusion.topics.selectors.SelectorComponents;
import net.jcip.annotations.Immutable;

@Immutable
class PathSelector
extends AbstractNonSetTopicSelector
implements TopicPathSelector {
    PathSelector(SelectorComponents components) {
        super(components);
        String prefix = components.getPrefix();
        if (prefix.isEmpty()) {
            throw new IllegalArgumentException("Topic path must have at least one part: \"" + components.getRemainder() + "\"");
        }
        if (prefix.contains("//")) {
            throw new IllegalArgumentException("Topic path contains empty part: \"" + components.getRemainder() + "\"");
        }
    }

    @Override
    public final String getPath() {
        return this.getPathPrefix();
    }

    @Override
    public final boolean confirmSelects(String path, DescendantQualifier dq) {
        int s = this.getPath().length();
        boolean match = s == path.length();
        switch (dq) {
            case MATCH: {
                return match;
            }
            case DESCENDANTS_OF_MATCH: {
                return !match && path.charAt(s) == '/';
            }
        }
        return match || path.charAt(s) == '/';
    }
}

