/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.topics.selectors;

import com.pushtechnology.diffusion.cache.Cache;
import com.pushtechnology.diffusion.client.topics.TopicSelector;
import com.pushtechnology.diffusion.java7.Streams;
import com.pushtechnology.diffusion.topics.selectors.AbstractTopicSelector;
import com.pushtechnology.diffusion.topics.selectors.DescendantQualifier;
import com.pushtechnology.diffusion.topics.selectors.SelectorComponents;
import com.pushtechnology.diffusion.topics.selectors.SelectorSet;
import com.pushtechnology.diffusion.topics.selectors.TopicSelectorParser;
import com.pushtechnology.diffusion.topics.tree.TopicPathUtilities;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@Immutable
public abstract class AbstractTopicSelectorParserImpl<T extends TopicSelector>
implements TopicSelectorParser {
    public static final String DELIMITER = "////";
    private static final Pattern DELIMITER_SPLIT_PATTERN = Pattern.compile("////(?!/)");
    private static final int EXPANSION_LIMIT = ConfigurationUtils.getIntegerSystemProperty("diffusion.split_path_disjunction_expansion_limit", 128);
    private final Cache<String, T> cache;
    private final Function<SelectorComponents, T> createPathSelector;
    private final CreateSplitPathSelector<T> createSplitPathSelector;
    private final CreateFullPathSelector<T> createFullPathSelector;
    private final CreateSetSelector<T> createSetSelector;

    protected AbstractTopicSelectorParserImpl(Cache<String, T> cache, Function<SelectorComponents, T> createPathSelector, CreateSplitPathSelector<T> createSplitPathSelector, CreateFullPathSelector<T> createFullPathSelector, CreateSetSelector<T> createSetSelector) {
        this.cache = cache;
        this.createPathSelector = createPathSelector;
        this.createSplitPathSelector = createSplitPathSelector;
        this.createFullPathSelector = createFullPathSelector;
        this.createSetSelector = createSetSelector;
    }

    public T parse(String expression) throws IllegalArgumentException {
        return this.parseInternal(expression, new ParseContext());
    }

    private T parseInternal(String expression, ParseContext context) {
        return (T)this.cache.computeIfAbsent(expression, k -> this.parseExpression((String)k, context));
    }

    @Override
    public TopicSelector selectorSet(List<? extends TopicSelector> selectors) {
        CreateSetSelector<TopicSelector> factory = SelectorSet::new;
        return AbstractTopicSelectorParserImpl.selectorSet(factory, selectors);
    }

    protected static final <X extends TopicSelector> X selectorSet(CreateSetSelector<X> factory, List<? extends X> selectors) {
        if (selectors.size() == 1) {
            return (X)((TopicSelector)selectors.get(0));
        }
        List<X> flattened = AbstractTopicSelectorParserImpl.flattenSelectors(Streams.stream(selectors));
        if (flattened.size() == 1) {
            return (X)((TopicSelector)flattened.get(0));
        }
        return factory.apply(flattened, AbstractTopicSelectorParserImpl.selectorSetRemainder(flattened), TopicSelector.Type.SELECTOR_SET);
    }

    private static String selectorSetRemainder(List<? extends TopicSelector> selectors) {
        StringBuilder remainder = new StringBuilder(selectors.size() * 30);
        for (TopicSelector topicSelector : selectors) {
            if (remainder.length() > 0) {
                remainder.append(DELIMITER);
            }
            ((AbstractTopicSelector)topicSelector).appendExpression(remainder);
        }
        return remainder.toString();
    }

    private static <X extends TopicSelector> List<X> flattenSelectors(Stream<? extends X> selectors) {
        return selectors.flatMap(s -> {
            if (s instanceof SelectorSet) {
                Collection nested = ((SelectorSet)s).getComponentSelectors();
                return Streams.stream(nested);
            }
            return Streams.streamOf(s);
        }).distinct().collect(Collectors.toList());
    }

    private T parseExpression(String expression, ParseContext context) throws IllegalArgumentException {
        SelectorComponents components = AbstractTopicSelectorParserImpl.parseComponents(expression);
        if (components.usePathSelector()) {
            return (T)((TopicSelector)this.createPathSelector.apply(components));
        }
        switch (components.getType()) {
            case SPLIT_PATH_PATTERN: {
                return this.parseSplitPatternSelector(components, context);
            }
            case FULL_PATH_PATTERN: {
                return this.parseFullPatternSelector(components);
            }
        }
        return this.parseSetSelector(components, context);
    }

    private T parseSplitPatternSelector(SelectorComponents components, ParseContext parseContext) {
        int prefixParts = TopicPathUtilities.countParts(components.getPrefix(), 0);
        String[] partExpressions = components.getSuffix().split(TopicPathUtilities.PATH_SEPARATOR_STRING, -1);
        StringPredicate[] predicates = new StringPredicate[partExpressions.length];
        String[] literals = new String[partExpressions.length];
        for (int i = 0; i < partExpressions.length; ++i) {
            String part = partExpressions[i];
            String context = "part #" + prefixParts + i + " of \"" + components.getRemainder() + "\"";
            if (part.isEmpty()) {
                throw new IllegalArgumentException("An empty regular expression will never match. [" + context + "]");
            }
            if (SelectorComponents.containsRegexMetaCharacters(part)) {
                T expanded;
                if (i == 0 && parseContext.getExpandedCount() < EXPANSION_LIMIT && (expanded = this.maybeExpandDisjunctionsToSelectorSet(components, part, parseContext)) != null) {
                    return expanded;
                }
                predicates[i] = AbstractTopicSelectorParserImpl.compilePredicate(part, context);
                continue;
            }
            predicates[i] = (p, s, e) -> AbstractTopicSelectorParserImpl.hasPathSuffix(p, s, e, part);
            literals[i] = "/" + part;
        }
        return this.createSplitPathSelector.apply(predicates, literals, components);
    }

    private T maybeExpandDisjunctionsToSelectorSet(SelectorComponents components, String part, ParseContext parseContext) {
        Stream<String> disjunctParts = AbstractTopicSelectorParserImpl.maybeExpandPartToDisjunctParts(part);
        if (disjunctParts == null) {
            return null;
        }
        String prefix = components.getPrefix();
        Object partTypeAndPrefix = prefix.isEmpty() ? "?" : "?" + prefix + "/";
        String partSuffix = components.getSuffix().substring(part.length());
        List expressions = disjunctParts.map(arg_0 -> AbstractTopicSelectorParserImpl.lambda$maybeExpandDisjunctionsToSelectorSet$3((String)partTypeAndPrefix, partSuffix, components, arg_0)).collect(Collectors.toList());
        parseContext.addToExpandedCount(expressions.size() - 1);
        return (T)this.createSetSelector.apply(AbstractTopicSelectorParserImpl.flattenSelectors(Streams.stream(expressions).map(e -> this.parseInternal((String)e, parseContext))), components.getRemainder(), TopicSelector.Type.SPLIT_PATH_PATTERN);
    }

    private static StringPredicate compilePredicate(String expression, String context) {
        if (AbstractTopicSelectorParserImpl.selectsAnything(expression)) {
            return (p, s, e) -> true;
        }
        Pattern pattern = AbstractTopicSelectorParserImpl.compileRegularExpression(expression, context);
        return (path, s, e) -> pattern.matcher(path.substring(s, e)).matches();
    }

    private static boolean selectsAnything(String expression) {
        return ".*".equals(expression) || ".*+".equals(expression) || ".+".equals(expression) || ".++".equals(expression);
    }

    private static boolean hasPathSuffix(String path, int start, int end, String suffix) {
        int length = end - start;
        return length == suffix.length() && path.regionMatches(start, suffix, 0, length);
    }

    private static Stream<String> maybeExpandPartToDisjunctParts(String part) {
        ArrayList<String> disjunctParts = null;
        int prefixEnd = 0;
        int s = 0;
        for (int i = 0; i < part.length(); ++i) {
            char c = part.charAt(i);
            if (disjunctParts == null && c == '(' && part.regionMatches(i + 1, "?:", 0, 2)) {
                prefixEnd = i;
                s = i + 3;
                i += 2;
                continue;
            }
            if (c == '|') {
                if (disjunctParts == null) {
                    disjunctParts = new ArrayList<String>();
                }
                disjunctParts.add(part.substring(s, i));
                s = i + 1;
                continue;
            }
            if (disjunctParts != null && c == ')') {
                String suffix = part.substring(i + 1);
                if (SelectorComponents.containsRegexMetaCharacters(suffix)) {
                    return null;
                }
                disjunctParts.add(part.substring(s, i));
                String prefix = part.substring(0, prefixEnd);
                return Streams.stream(disjunctParts).map(d -> prefix + d + suffix);
            }
            if (!SelectorComponents.isRegexMetaCharacter(c)) continue;
            return null;
        }
        assert (disjunctParts != null) : part;
        disjunctParts.add(part.substring(s));
        String prefix = part.substring(0, prefixEnd);
        return Streams.stream(disjunctParts).map(d -> prefix + d);
    }

    private T parseFullPatternSelector(SelectorComponents components) {
        String baseRegex = components.getBase();
        if (baseRegex.contains(DELIMITER)) {
            throw new IllegalArgumentException("Regular expression contains illegal sequence \"////\"");
        }
        String context = "in full path pattern \"" + components.getRemainder() + "\"";
        Pattern selectTreePattern = AbstractTopicSelectorParserImpl.compileRegularExpression(baseRegex, context);
        Pattern selectsPattern = AbstractTopicSelectorParserImpl.compileRegularExpression((String)(switch (components.getQualifier()) {
            case DescendantQualifier.MATCH -> baseRegex;
            case DescendantQualifier.DESCENDANTS_OF_MATCH -> baseRegex + "/.+";
            default -> baseRegex + "(?:$|/.+)";
        }), context);
        return this.createFullPathSelector.apply(selectTreePattern, selectsPattern, components);
    }

    private static Stream<String> splitRemainder(String remainder) {
        if (remainder.isEmpty()) {
            return Stream.empty();
        }
        return DELIMITER_SPLIT_PATTERN.splitAsStream(remainder);
    }

    private T parseSetSelector(SelectorComponents components, ParseContext context) {
        List selectors = AbstractTopicSelectorParserImpl.splitRemainder(components.getRemainder()).map(e -> this.parseInternal((String)e, context)).distinct().collect(Collectors.toList());
        if (selectors.size() == 1) {
            return (T)((TopicSelector)selectors.get(0));
        }
        return this.createSetSelector.apply(selectors, AbstractTopicSelectorParserImpl.selectorSetRemainder(selectors), TopicSelector.Type.SELECTOR_SET);
    }

    private static Pattern compileRegularExpression(String expression, String context) {
        if (expression.isEmpty()) {
            throw new IllegalArgumentException("An empty regular expression will never match. [" + context + "]");
        }
        try {
            return Pattern.compile(expression);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Bad regular expression [" + e.getMessage() + ", " + context + "]", e);
        }
    }

    private static SelectorComponents parseComponents(String expression) {
        TopicSelector.Type type;
        if (expression.isEmpty()) {
            throw new IllegalArgumentException("Empty expression");
        }
        char first = expression.charAt(0);
        return SelectorComponents.create(type, switch (first) {
            case '>' -> {
                type = TopicSelector.Type.PATH;
                yield expression.substring(1);
            }
            case '?' -> {
                type = TopicSelector.Type.SPLIT_PATH_PATTERN;
                yield AbstractTopicSelectorParserImpl.optimiseSplitPathSuffix(expression.substring(1));
            }
            case '*' -> {
                type = TopicSelector.Type.FULL_PATH_PATTERN;
                yield AbstractTopicSelectorParserImpl.optimiseFullPathSuffix(expression.substring(1));
            }
            case '#' -> {
                type = TopicSelector.Type.SELECTOR_SET;
                yield expression.substring(1);
            }
            case '$', '%', '&', '<' -> throw new IllegalArgumentException("Unknown expression type: " + expression);
            default -> {
                type = TopicSelector.Type.PATH;
                yield expression;
            }
        });
    }

    private static String optimiseFullPathSuffix(String path) {
        if (path.length() > 5 && path.endsWith("/.*//")) {
            return path.substring(0, path.length() - 4);
        }
        if (path.length() > 3 && path.endsWith("/.*")) {
            return path.substring(0, path.length() - 2);
        }
        if (path.endsWith(".*")) {
            return path + "//";
        }
        return path;
    }

    private static String optimiseSplitPathSuffix(String path) {
        int l = path.length();
        if (l > 5 && path.startsWith("/.*//", l - 5)) {
            l -= 4;
            while (l > 4 && path.startsWith("/.*", l - 4)) {
                l -= 3;
            }
            return path.substring(0, l);
        }
        return path;
    }

    private static /* synthetic */ String lambda$maybeExpandDisjunctionsToSelectorSet$3(String partTypeAndPrefix, String partSuffix, SelectorComponents components, String p) {
        return partTypeAndPrefix + p + partSuffix + components.getQualifier().getSuffix();
    }

    @FunctionalInterface
    protected static interface CreateSplitPathSelector<T extends TopicSelector> {
        public T apply(StringPredicate[] var1, String[] var2, SelectorComponents var3);
    }

    @FunctionalInterface
    protected static interface CreateFullPathSelector<T extends TopicSelector> {
        public T apply(Pattern var1, Pattern var2, SelectorComponents var3);
    }

    @FunctionalInterface
    protected static interface CreateSetSelector<T extends TopicSelector> {
        public T apply(Collection<T> var1, String var2, TopicSelector.Type var3);
    }

    @NotThreadSafe
    private static final class ParseContext {
        private int expanded = 1;

        private ParseContext() {
        }

        int getExpandedCount() {
            return this.expanded;
        }

        void addToExpandedCount(int i) {
            this.expanded += i;
        }
    }

    @FunctionalInterface
    protected static interface StringPredicate {
        public boolean test(String var1, int var2, int var3);
    }
}

