/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.topics.details.serialisers;

import com.pushtechnology.diffusion.client.types.serialisation.EnumConverter;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.topics.details.TopicProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
abstract class AbstractTopicPropertiesSerialiser
extends AbstractSerialiser<TopicProperties> {
    private final EnumConverter<TopicProperties.Key> keyConverter;

    AbstractTopicPropertiesSerialiser(EnumConverter<TopicProperties.Key> keyConverter) {
        this.keyConverter = keyConverter;
    }

    @Override
    public final void write(OutputStream out, TopicProperties value) throws IOException {
        Map<TopicProperties.Key, String> map = value.getPropertyMap();
        int filteredSize = 0;
        for (Map.Entry<TopicProperties.Key, String> entry : map.entrySet()) {
            if (!this.keyConverter.isMapped(entry.getKey())) continue;
            ++filteredSize;
        }
        EncodedDataCodec.writeInt32(out, filteredSize);
        for (Map.Entry<TopicProperties.Key, String> entry : map.entrySet()) {
            TopicProperties.Key k = entry.getKey();
            if (!this.keyConverter.isMapped(k)) continue;
            EncodedDataCodec.writeByte(out, this.keyConverter.toByte(k));
            EncodedDataCodec.writeString(out, entry.getValue());
        }
    }

    @Override
    protected final TopicProperties readUnchecked(InputStream in) throws IOException {
        int n = EncodedDataCodec.readInt32(in);
        HashMap<TopicProperties.Key, String> map = new HashMap<TopicProperties.Key, String>(n);
        for (int i = 0; i < n; ++i) {
            byte b = EncodedDataCodec.readByte(in);
            String v = EncodedDataCodec.readString(in);
            TopicProperties.Key k = this.keyConverter.fromByte(b, null);
            if (k == null) continue;
            map.put(k, v);
        }
        return new TopicProperties(map);
    }
}

