/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.topics.details;

import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.collections.ImmutableSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public final class TopicPropertyNormalisers {
    private static final ImmutableSet<String> SUPPORTED_KEYS = ImmutableSet.of(new String[]{"COMPRESSION", "CONFLATION", "_CREATOR", "DONT_RETAIN_VALUE", "OWNER", "PERSISTENT", "PRIORITY", "PUBLISH_VALUES_ONLY", "REMOVAL", "SCHEMA", "TIDY_ON_UNSUBSCRIBE", "TIME_SERIES_EVENT_VALUE_TYPE", "TIME_SERIES_SUBSCRIPTION_RANGE", "TIME_SERIES_RETAINED_RANGE", "VALIDATE_VALUES", "_VIEW", "_ALERT"});
    public static final TopicPropertyNormalisers NORMALISERS = new TopicPropertyNormalisers();
    private final EnumMap<TopicType, Normaliser> normalisers = new EnumMap(TopicType.class);

    private TopicPropertyNormalisers() {
        HashMap<String, ValueNormaliser> standardNormalisers = new HashMap<String, ValueNormaliser>();
        standardNormalisers.put("COMPRESSION", TopicPropertyNormalisers.normaliseLowerCaseWithDefault("low"));
        standardNormalisers.put("CONFLATION", TopicPropertyNormalisers.normaliseLowerCaseWithDefault("conflate"));
        standardNormalisers.put("DONT_RETAIN_VALUE", TopicPropertyNormalisers::normaliseBooleanDefaultFalse);
        standardNormalisers.put("PERSISTENT", TopicPropertyNormalisers::normaliseBooleanDefaultTrue);
        standardNormalisers.put("PUBLISH_VALUES_ONLY", TopicPropertyNormalisers::normaliseBooleanDefaultFalse);
        standardNormalisers.put("TIDY_ON_UNSUBSCRIBE", TopicPropertyNormalisers::normaliseBooleanDefaultFalse);
        standardNormalisers.put("TIME_SERIES_EVENT_VALUE_TYPE", String::toLowerCase);
        standardNormalisers.put("TIME_SERIES_RETAINED_RANGE", String::toLowerCase);
        standardNormalisers.put("TIME_SERIES_SUBSCRIPTION_RANGE", String::toLowerCase);
        standardNormalisers.put("VALIDATE_VALUES", TopicPropertyNormalisers::normaliseBooleanDefaultFalse);
        Normaliser stringBinaryJson = TopicPropertyNormalisers.toNormaliser(TopicPropertyNormalisers.valueNormalisersWithout(standardNormalisers, "SCHEMA", "TIME_SERIES_EVENT_VALUE_TYPE", "TIME_SERIES_RETAINED_RANGE", "TIME_SERIES_SUBSCRIPTION_RANGE"));
        this.normalisers.put(TopicType.STRING, stringBinaryJson);
        this.normalisers.put(TopicType.JSON, stringBinaryJson);
        this.normalisers.put(TopicType.BINARY, stringBinaryJson);
        Normaliser numbers = TopicPropertyNormalisers.toNormaliser(TopicPropertyNormalisers.valueNormalisersWithout(standardNormalisers, "COMPRESSION", "PUBLISH_VALUES_ONLY", "SCHEMA", "TIME_SERIES_EVENT_VALUE_TYPE", "TIME_SERIES_RETAINED_RANGE", "TIME_SERIES_SUBSCRIPTION_RANGE"));
        this.normalisers.put(TopicType.DOUBLE, numbers);
        this.normalisers.put(TopicType.INT64, numbers);
        this.normalisers.put(TopicType.RECORD_V2, TopicPropertyNormalisers.toNormaliser(TopicPropertyNormalisers.valueNormalisersWithout(standardNormalisers, "TIME_SERIES_EVENT_VALUE_TYPE", "TIME_SERIES_RETAINED_RANGE", "TIME_SERIES_SUBSCRIPTION_RANGE")));
        Map<String, ValueNormaliser> timeSeries = TopicPropertyNormalisers.valueNormalisersWithout(standardNormalisers, "CONFLATION", "DONT_RETAIN_VALUE", "SCHEMA");
        timeSeries.put("CONFLATION", TopicPropertyNormalisers.normaliseLowerCaseWithDefault("off"));
        this.normalisers.put(TopicType.TIME_SERIES, TopicPropertyNormalisers.toNormaliser(timeSeries));
        this.normalisers.put(TopicType.UNKNOWN_TOPIC_TYPE, (k, v) -> null);
        assert (this.normalisers.size() == TopicType.values().length);
    }

    private static Normaliser toNormaliser(Map<String, ValueNormaliser> valueNormaliser) {
        return (k, v) -> {
            ValueNormaliser vn = (ValueNormaliser)valueNormaliser.get(k);
            return vn != null ? (String)vn.apply(v) : null;
        };
    }

    private static Map<String, ValueNormaliser> valueNormalisersWithout(Map<String, ValueNormaliser> standardNormalisers, String ... without) {
        HashMap<String, ValueNormaliser> result = new HashMap<String, ValueNormaliser>();
        Iterator<String> iterator = SUPPORTED_KEYS.without(ImmutableSet.of(without)::contains).iterator();
        while (iterator.hasNext()) {
            String k;
            ValueNormaliser n = standardNormalisers.get(k = iterator.next());
            result.put(k, n != null ? n : x -> x);
        }
        return result;
    }

    private static String normaliseBooleanDefaultTrue(String value) {
        return Boolean.parseBoolean(value) ? null : "false";
    }

    private static String normaliseBooleanDefaultFalse(String value) {
        return !Boolean.parseBoolean(value) ? null : "true";
    }

    private static ValueNormaliser normaliseLowerCaseWithDefault(String defaultValue) {
        return v -> defaultValue.equalsIgnoreCase((String)v) ? null : v.toLowerCase();
    }

    static String checkKey(String key) {
        if (!SUPPORTED_KEYS.contains(Objects.requireNonNull(key, "property key is null"))) {
            throw new IllegalArgumentException("invalid key '" + key + "'");
        }
        return key;
    }

    public Normaliser normaliserFor(TopicType type) {
        return this.normalisers.get((Object)type);
    }

    public Map<String, String> normaliseProperties(TopicType type, Map<String, String> properties) {
        if (properties.isEmpty()) {
            return Collections.emptyMap();
        }
        Normaliser normaliser = this.normaliserFor(type);
        HashMap<String, String> newProperties = new HashMap<String, String>(properties.size());
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String newValue = normaliser.normaliseValue(key, entry.getValue());
            if (newValue == null) continue;
            newProperties.put(key, newValue);
        }
        return newProperties;
    }

    private static interface ValueNormaliser
    extends Function<String, String> {
    }

    @FunctionalInterface
    public static interface Normaliser {
        public String normaliseValue(String var1, String var2);
    }
}

