/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.topics.details;

import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.client.types.serialisation.EnumConverter;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.topics.details.TopicPropertyNormalisers;
import com.pushtechnology.diffusion.topics.details.TopicSpecificationImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import net.jcip.annotations.Immutable;

@Immutable
abstract class AbstractTopicSpecificationSerialiser
extends AbstractSerialiser<TopicSpecification> {
    private final EnumConverter<TopicType> typeConverter;

    AbstractTopicSpecificationSerialiser(EnumConverter<TopicType> typeConverter) {
        this.typeConverter = typeConverter;
    }

    @Override
    public final void write(OutputStream out, TopicSpecification value) throws IOException {
        EncodedDataCodec.writeByte(out, this.typeConverter.toByte(value.getType()));
        ((TopicSpecificationImpl)value).serialiseProperties(out);
    }

    @Override
    protected final TopicSpecificationImpl readUnchecked(InputStream in) throws IOException {
        byte typeByte = EncodedDataCodec.readByte(in);
        TopicType type = this.typeConverter.fromByte(typeByte, TopicType.UNKNOWN_TOPIC_TYPE);
        int n = EncodedDataCodec.readInt32(in);
        if (n == 0) {
            return new TopicSpecificationImpl(type);
        }
        TopicPropertyNormalisers.Normaliser normaliser = TopicPropertyNormalisers.NORMALISERS.normaliserFor(type);
        HashMap<String, String> properties = new HashMap<String, String>(n);
        for (int i = 0; i < n; ++i) {
            String v;
            String k = EncodedDataCodec.readString(in);
            String normalisedValue = normaliser.normaliseValue(k, v = EncodedDataCodec.readString(in));
            if (normalisedValue == null) continue;
            properties.put(k, normalisedValue);
        }
        return new TopicSpecificationImpl(Collections.unmodifiableMap(properties), type);
    }
}

