/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.timeseries.update;

import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.timeseries.update.TimeSeriesAppendRequest;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class TimeSeriesTimestampAppendRequest
extends TimeSeriesAppendRequest {
    private final long timestamp;

    public TimeSeriesTimestampAppendRequest(String topicPath, DataType<?> dataType, IBytes value, long timestamp) {
        super(topicPath, dataType, value);
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimeSeriesTimestampAppendRequest that = (TimeSeriesTimestampAppendRequest)o;
        return this.timestamp == that.timestamp;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.timestamp);
    }

    @Override
    public String toString() {
        return "appendTimestamp(\"" + this.getTopicPath() + "\", " + String.valueOf(this.getDataType()) + ", " + String.valueOf(this.getValue()) + ", " + this.timestamp + ")";
    }

    @Override
    public Map<String, Object> getJournableContext() {
        Map<String, Object> context = super.getJournableContext();
        context.put("timestamp", this.timestamp);
        return context;
    }
}

