/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.timeseries.update;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.datatype.DataTypes;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.TrailingBytesWriteSerialiser;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.timeseries.update.TimeSeriesEditRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="time-series-edit-request", valueType=TimeSeriesEditRequest.class)
public final class TimeSeriesEditRequestSerialiser
extends AbstractSerialiser<TimeSeriesEditRequest>
implements TrailingBytesWriteSerialiser<TimeSeriesEditRequest> {
    private final DataTypes dataTypes;

    public TimeSeriesEditRequestSerialiser(DataTypes dataTypes) {
        this.dataTypes = dataTypes;
    }

    @Override
    public void writeHead(OutputStream out, TimeSeriesEditRequest value) throws IOException {
        EncodedDataCodec.writeString(out, value.getTopicPath());
        EncodedDataCodec.writeString(out, value.getDataType().getTypeName());
        EncodedDataCodec.writeInt64(out, value.getOriginalSequence());
    }

    @Override
    public IBytes getTail(TimeSeriesEditRequest request) {
        return request.getValue();
    }

    @Override
    protected TimeSeriesEditRequest readUnchecked(InputStream in) throws IOException {
        String topicPath = EncodedDataCodec.readString(in);
        DataType<?> dataType = this.dataTypes.getByName(EncodedDataCodec.readString(in));
        long originalSequence = EncodedDataCodec.readInt64(in);
        IBytes request = IBytes.toIBytes(EncodedDataCodec.readByteArray(in));
        return new TimeSeriesEditRequest(topicPath, dataType, originalSequence, request);
    }
}

