/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.timeseries.update;

import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.java7.Java7;
import com.pushtechnology.diffusion.journal.Journable;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public final class TimeSeriesEditRequest
implements Journable {
    private final String topicPath;
    private final DataType<?> dataType;
    private final long originalSequence;
    private final IBytes value;

    public TimeSeriesEditRequest(String topicPath, DataType<?> dataType, long originalSequence, IBytes value) {
        this.topicPath = topicPath;
        this.dataType = dataType;
        this.originalSequence = originalSequence;
        this.value = value;
    }

    public String getTopicPath() {
        return this.topicPath;
    }

    public DataType<?> getDataType() {
        return this.dataType;
    }

    public long getOriginalSequence() {
        return this.originalSequence;
    }

    public IBytes getValue() {
        return this.value;
    }

    public int hashCode() {
        int result = this.topicPath.hashCode();
        result = 31 * result + this.dataType.hashCode();
        result = 31 * result + this.value.hashCode();
        result = 31 * result + Java7.longHashCode(this.originalSequence);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeSeriesEditRequest)) {
            return false;
        }
        TimeSeriesEditRequest other = (TimeSeriesEditRequest)o;
        return this.originalSequence == other.originalSequence && this.topicPath.equals(other.topicPath) && this.dataType.equals(other.dataType) && this.value.equals(other.value);
    }

    public String toString() {
        return "edit(\"" + this.topicPath + "\", " + String.valueOf(this.dataType) + ", " + this.originalSequence + ", " + String.valueOf(this.value) + ")";
    }

    @Override
    public Map<String, Object> getJournableContext() {
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>(3);
        context.put("path", this.topicPath);
        context.put("type", this.dataType.getTypeName());
        context.put("sequence", this.originalSequence);
        return context;
    }
}

