/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.timeseries.update;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.datatype.DataTypes;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.TrailingBytesWriteSerialiser;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.timeseries.update.TimeSeriesAppendRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="time-series-append-request", valueType=TimeSeriesAppendRequest.class)
public final class TimeSeriesAppendRequestSerialiser
extends AbstractSerialiser<TimeSeriesAppendRequest>
implements TrailingBytesWriteSerialiser<TimeSeriesAppendRequest> {
    private final DataTypes dataTypes;

    public TimeSeriesAppendRequestSerialiser(DataTypes dataTypes) {
        this.dataTypes = dataTypes;
    }

    @Override
    public void writeHead(OutputStream out, TimeSeriesAppendRequest value) throws IOException {
        EncodedDataCodec.writeString(out, value.getTopicPath());
        EncodedDataCodec.writeString(out, value.getDataType().getTypeName());
    }

    @Override
    public IBytes getTail(TimeSeriesAppendRequest request) {
        return request.getValue();
    }

    @Override
    protected TimeSeriesAppendRequest readUnchecked(InputStream in) throws IOException {
        String topicPath = EncodedDataCodec.readString(in);
        DataType<?> dataType = this.dataTypes.getByName(EncodedDataCodec.readString(in));
        IBytes request = IBytes.toIBytes(EncodedDataCodec.readByteArray(in));
        return new TimeSeriesAppendRequest(topicPath, dataType, request);
    }
}

