/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.timeseries.query;

import com.pushtechnology.diffusion.client.features.IncompatibleTopicException;
import com.pushtechnology.diffusion.client.features.TimeSeries;
import com.pushtechnology.diffusion.datatype.Bytes;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.java7.Java7;
import com.pushtechnology.diffusion.timeseries.query.QueryResultImpl;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public final class RangeQueryResult {
    private final DataType<?> valueDataType;
    private final long selectedCount;
    private final List<TimeSeries.Event<IBytes>> events;

    public RangeQueryResult(DataType<?> valueDataType, long selectedCount, List<TimeSeries.Event<IBytes>> events) {
        this.valueDataType = valueDataType;
        this.selectedCount = selectedCount;
        this.events = events;
    }

    public DataType<?> valueDataType() {
        return this.valueDataType;
    }

    public long selectedCount() {
        return this.selectedCount;
    }

    public List<TimeSeries.Event<IBytes>> events() {
        return this.events;
    }

    <V> TimeSeries.QueryResult<V> createQueryResult(Class<? extends V> queryValueType, TimeSeries.QueryResult.StreamStructure streamStructure) {
        if (!this.valueDataType.canReadAs(queryValueType)) {
            throw new IncompatibleTopicException("Time series topic has an incompatible event data type: " + String.valueOf(this.valueDataType));
        }
        return new QueryResultImpl(this.selectedCount, streamStructure, this.events, rawEvent -> {
            Object value = this.valueDataType.readAs(queryValueType, (Bytes)rawEvent.value());
            return rawEvent.withValue(value);
        });
    }

    public int hashCode() {
        int result = this.valueDataType.hashCode();
        result = 31 * result + Java7.longHashCode(this.selectedCount);
        result = 31 * result + this.events.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RangeQueryResult)) {
            return false;
        }
        RangeQueryResult other = (RangeQueryResult)o;
        return this.selectedCount == other.selectedCount && this.valueDataType == other.valueDataType && this.events.equals(other.events);
    }

    public String toString() {
        return "RangeQueryResult event data type=" + String.valueOf(this.valueDataType) + " selected count=" + this.selectedCount + " event count=" + this.events.size();
    }
}

