/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.timeseries.query;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.timeseries.query.RangeQueryParameters;
import com.pushtechnology.diffusion.timeseries.query.RangeQueryParametersSerialiser;
import com.pushtechnology.diffusion.timeseries.query.RangeQueryRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="range-query-request", valueType=RangeQueryRequest.class)
public class RangeQueryRequestSerialiser
extends AbstractSerialiser<RangeQueryRequest> {
    private final RangeQueryParametersSerialiser parametersSerialiser;

    public RangeQueryRequestSerialiser(RangeQueryParametersSerialiser parametersSerialiser) {
        this.parametersSerialiser = parametersSerialiser;
    }

    @Override
    public void write(OutputStream out, RangeQueryRequest value) throws IOException {
        EncodedDataCodec.writeString(out, value.getTopicPath());
        this.parametersSerialiser.write(out, value.getParameters());
    }

    @Override
    protected RangeQueryRequest readUnchecked(InputStream in) throws IOException {
        String topicPath = EncodedDataCodec.readString(in);
        RangeQueryParameters paramaters = (RangeQueryParameters)this.parametersSerialiser.read(in);
        return new RangeQueryRequest(topicPath, paramaters);
    }
}

