/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.timeseries.query;

import com.pushtechnology.diffusion.client.features.TimeSeries;
import com.pushtechnology.diffusion.java7.Java7;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class RangeQueryParameters {
    private static final Point START_POINT = new Point(0L, Point.Type.ABSOLUTE_START);
    static final Range DEFAULT_RANGE = new Range(Point.atStart(), Point.offset(0L));
    public static final RangeQueryParameters DEFAULT_RANGE_QUERY = new RangeQueryParameters(QueryType.VALUES, DEFAULT_RANGE, DEFAULT_RANGE, Long.MAX_VALUE);
    public static final RangeQueryParameters ENTIRE_RANGE = DEFAULT_RANGE_QUERY.withQueryType(QueryType.ALL_EDITS);
    private final QueryType queryType;
    private final Range viewRange;
    private final Range editRange;
    private final long limit;

    RangeQueryParameters(QueryType queryType, Range valueRange, Range editRange, long limit) {
        this.queryType = queryType;
        this.viewRange = valueRange;
        this.editRange = editRange;
        this.limit = limit;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public Range getViewRange() {
        return this.viewRange;
    }

    public Range getEditRange() {
        return this.editRange;
    }

    public long getLimit() {
        return this.limit;
    }

    public RangeQueryParameters withViewRange(Range r) {
        return new RangeQueryParameters(this.queryType, r, this.editRange, this.limit);
    }

    public RangeQueryParameters withEditRange(Range r) {
        return new RangeQueryParameters(this.queryType, this.viewRange, r, this.limit);
    }

    public RangeQueryParameters withLimit(long count) {
        return new RangeQueryParameters(this.queryType, this.viewRange, this.editRange, RangeQueryParameters.requireNonNegative("count", count));
    }

    public RangeQueryParameters withQueryType(QueryType type) {
        return new RangeQueryParameters(type, this.viewRange, this.editRange, this.limit);
    }

    public boolean isHistoricQuery() {
        return this.queryType != QueryType.VALUES || !this.editRange.equals(DEFAULT_RANGE);
    }

    private static long requireNonNegative(String what, long value) {
        if (value < 0L) {
            throw new IllegalArgumentException(what + " is negative: " + value);
        }
        return value;
    }

    public int hashCode() {
        int result = this.viewRange.hashCode();
        result = 31 * result + this.editRange.hashCode();
        result = 31 * result + Java7.longHashCode(this.limit);
        result = 31 * result + this.queryType.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangeQueryParameters)) {
            return false;
        }
        RangeQueryParameters other = (RangeQueryParameters)o;
        return this.limit == other.limit && this.queryType.equals((Object)other.queryType) && this.viewRange.equals(other.viewRange) && this.editRange.equals(other.editRange);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("rangeQuery()");
        if (this.queryType != QueryType.VALUES) {
            sb.append(this.queryType.primaryOperator);
        }
        if (!this.viewRange.equals(RangeQueryParameters.DEFAULT_RANGE_QUERY.viewRange)) {
            sb.append(this.viewRange);
        }
        if (!this.editRange.equals(RangeQueryParameters.DEFAULT_RANGE_QUERY.editRange)) {
            sb.append(this.queryType.editRangeOperator).append(this.editRange);
        } else if (this.queryType == QueryType.LATEST_EDITS) {
            sb.append(QueryType.LATEST_EDITS.editRangeOperator);
        }
        if (this.limit != RangeQueryParameters.DEFAULT_RANGE_QUERY.limit) {
            sb.append(".limit(").append(this.limit).append(')');
        }
        return sb.toString();
    }

    public static enum QueryType {
        VALUES(".forValues()", ".editRange()", TimeSeries.QueryResult.StreamStructure.VALUE_EVENT_STREAM),
        ALL_EDITS(".forEdits()", ".allEdits()", TimeSeries.QueryResult.StreamStructure.EDIT_EVENT_STREAM),
        LATEST_EDITS(".forEdits()", ".latestEdits()", TimeSeries.QueryResult.StreamStructure.EDIT_EVENT_STREAM);

        private final String primaryOperator;
        private final String editRangeOperator;
        private final TimeSeries.QueryResult.StreamStructure streamStructure;

        private QueryType(String primaryOperator, String editRangeOperator, TimeSeries.QueryResult.StreamStructure streamStructure) {
            this.primaryOperator = primaryOperator;
            this.editRangeOperator = editRangeOperator;
            this.streamStructure = streamStructure;
        }

        TimeSeries.QueryResult.StreamStructure streamStructure() {
            return this.streamStructure;
        }
    }

    @Immutable
    public static final class Range {
        private final Point anchor;
        private final Point span;

        Range(Point anchor, Point end) {
            assert (anchor.isAbsolute());
            this.anchor = anchor;
            this.span = end;
        }

        public Range from(long sequence) {
            return new Range(Point.at(sequence), this.span);
        }

        public Range fromStart() {
            return new Range(Point.atStart(), this.span);
        }

        public Range from(Instant instant) {
            return new Range(Point.at(instant), this.span);
        }

        public Range from(Date date) {
            return new Range(Point.at(date), this.span);
        }

        public Range fromLast(long count) {
            return new Range(Point.offset(count), this.span);
        }

        public Range fromLast(Duration timeSpan) {
            return new Range(Point.offset(timeSpan), this.span);
        }

        public Range fromLastMillis(long timeSpan) {
            return new Range(Point.offsetMillis(timeSpan), this.span);
        }

        public Range to(long sequence) {
            return new Range(this.anchor, Point.at(sequence));
        }

        public Range toStart() {
            return new Range(this.anchor, Point.atStart());
        }

        public Range to(Instant instant) {
            return new Range(this.anchor, Point.at(instant));
        }

        public Range to(Date date) {
            return new Range(this.anchor, Point.at(date));
        }

        public Range untilLast(long count) {
            return new Range(this.anchor, Point.offset(count));
        }

        public Range untilLast(Duration timeSpan) {
            return new Range(this.anchor, Point.offset(timeSpan));
        }

        public Range untilLastMillis(long timeSpan) {
            return new Range(this.anchor, Point.offsetMillis(timeSpan));
        }

        public Range next(long count) {
            return new Range(this.anchor, Point.next(count));
        }

        public Range next(Duration timeSpan) {
            return new Range(this.anchor, Point.next(timeSpan));
        }

        public Range nextMillis(long timeSpan) {
            return new Range(this.anchor, Point.nextMillis(timeSpan));
        }

        public Range previous(long count) {
            return new Range(this.anchor, Point.previous(count));
        }

        public Range previous(Duration timeSpan) {
            return new Range(this.anchor, Point.previous(timeSpan));
        }

        public Range previousMillis(long timeSpan) {
            return new Range(this.anchor, Point.previousMillis(timeSpan));
        }

        public Point getAnchor() {
            return this.anchor;
        }

        public Point getSpan() {
            return this.span;
        }

        public int hashCode() {
            return 31 * this.anchor.hashCode() + this.span.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Range)) {
                return false;
            }
            Range other = (Range)o;
            return this.anchor.equals(other.anchor) && this.span.equals(other.span);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (!this.anchor.equals(RangeQueryParameters.DEFAULT_RANGE.anchor)) {
                sb.append(this.anchor.toAnchorDescription());
            }
            if (!this.span.equals(RangeQueryParameters.DEFAULT_RANGE.span)) {
                sb.append(this.span.toSpanDescription());
            }
            return sb.toString();
        }
    }

    @Immutable
    public static final class Point {
        private final long value;
        private final Type type;

        static Point atStart() {
            return START_POINT;
        }

        static Point at(long sequence) {
            return new Point(RangeQueryParameters.requireNonNegative("sequence", sequence), Type.ABSOLUTE_SEQUENCE);
        }

        static Point at(Instant instant) {
            return new Point(Objects.requireNonNull(instant, "instant is null").toEpochMilli(), Type.ABSOLUTE_TIME);
        }

        static Point at(Date date) {
            return new Point(Objects.requireNonNull(date, "date is null").getTime(), Type.ABSOLUTE_TIME);
        }

        static Point offset(long count) {
            return new Point(RangeQueryParameters.requireNonNegative("count", count), Type.OFFSET_SEQUENCE);
        }

        static Point offset(Duration timeSpan) {
            return Point.offsetMillis(Objects.requireNonNull(timeSpan, "timeSpan").toMillis());
        }

        static Point offsetMillis(long timeSpan) {
            return new Point(RangeQueryParameters.requireNonNegative("timeSpan", timeSpan), Type.OFFSET_TIME);
        }

        static Point next(long count) {
            return new Point(RangeQueryParameters.requireNonNegative("count", count), Type.NEXT_COUNT);
        }

        static Point previous(long count) {
            return new Point(RangeQueryParameters.requireNonNegative("count", count), Type.PREVIOUS_COUNT);
        }

        static Point next(Duration timeSpan) {
            return Point.nextMillis(Objects.requireNonNull(timeSpan, "timeSpan").toMillis());
        }

        static Point nextMillis(long timeSpan) {
            return new Point(RangeQueryParameters.requireNonNegative("timeSpan", timeSpan), Type.NEXT_TIME);
        }

        static Point previous(Duration timeSpan) {
            return Point.previousMillis(Objects.requireNonNull(timeSpan, "timeSpan").toMillis());
        }

        static Point previousMillis(long timeSpan) {
            return new Point(RangeQueryParameters.requireNonNegative("timeSpan", timeSpan), Type.PREVIOUS_TIME);
        }

        Point(long value, Type type) {
            assert (type.validate(value)) : value + " is not a valid " + String.valueOf((Object)type);
            this.value = value;
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        public boolean isAbsolute() {
            return this.type.anchorOperator != null;
        }

        public long getValue() {
            return this.value;
        }

        private String toOperatorDescription(String operator) {
            StringBuilder sb = new StringBuilder();
            sb.append('.').append(operator).append('(');
            if (this.type != Type.ABSOLUTE_START) {
                sb.append(this.value).append(this.type.unitsSuffix);
            }
            sb.append(')');
            return sb.toString();
        }

        String toAnchorDescription() {
            return this.toOperatorDescription(this.type.anchorOperator);
        }

        String toSpanDescription() {
            return this.toOperatorDescription(this.type.spanOperator);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + Java7.longHashCode(this.value);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Point)) {
                return false;
            }
            Point other = (Point)o;
            return this.value == other.value && this.type.equals((Object)other.type);
        }

        public String toString() {
            return this.type.toString() + " " + this.value;
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum Type {
            ABSOLUTE_START("fromStart", "toStart", ""){

                @Override
                boolean validate(long v) {
                    return true;
                }
            }
            ,
            ABSOLUTE_SEQUENCE("from", "to", ""),
            ABSOLUTE_TIME("from", "to", " ms"){

                @Override
                boolean validate(long v) {
                    return true;
                }
            }
            ,
            OFFSET_SEQUENCE("fromLast", "untilLast", ""),
            OFFSET_TIME("fromLast", "untilLast", " ms"),
            NEXT_COUNT(null, "next", ""),
            NEXT_TIME(null, "next", " ms"),
            PREVIOUS_COUNT(null, "previous", ""),
            PREVIOUS_TIME(null, "previous", " ms");

            private final String anchorOperator;
            private final String spanOperator;
            private final String unitsSuffix;

            private Type(String anchorOperator, String spanOperator, String unitsSuffix) {
                this.anchorOperator = anchorOperator;
                this.spanOperator = spanOperator;
                this.unitsSuffix = unitsSuffix;
            }

            boolean validate(long v) {
                return v >= 0L;
            }
        }
    }
}

