/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.timeseries.query;

import com.pushtechnology.diffusion.client.features.TimeSeries;
import com.pushtechnology.diffusion.command.sender.ServiceReference;
import com.pushtechnology.diffusion.datatype.Bytes;
import com.pushtechnology.diffusion.timeseries.query.RangeQueryParameters;
import com.pushtechnology.diffusion.timeseries.query.RangeQueryRequest;
import com.pushtechnology.diffusion.timeseries.query.RangeQueryResult;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.jcip.annotations.Immutable;

@Immutable
public final class RangeQueryImpl<V>
implements TimeSeries.RangeQuery<V> {
    private final Context context;
    private final Class<V> valueType;
    private final RangeQueryParameters parameters;
    private final Mode mode;

    public static TimeSeries.RangeQuery<Bytes> createDefault(ServiceReference<RangeQueryRequest, RangeQueryResult> service) {
        return new RangeQueryImpl<Bytes>(new Context(service), Bytes.class, RangeQueryParameters.DEFAULT_RANGE_QUERY, Mode.VIEW_RANGE);
    }

    private RangeQueryImpl(Context context, Class<V> valueType, RangeQueryParameters parameters, Mode mode) {
        this.context = context;
        this.valueType = valueType;
        this.parameters = parameters;
        this.mode = mode;
    }

    @Override
    public TimeSeries.RangeQuery<V> forValues() {
        return new RangeQueryImpl<V>(this.context, this.valueType, this.parameters.withQueryType(RangeQueryParameters.QueryType.VALUES).withViewRange(RangeQueryParameters.DEFAULT_RANGE), Mode.VIEW_RANGE);
    }

    @Override
    public TimeSeries.RangeQuery<V> forEdits() {
        return new RangeQueryImpl<V>(this.context, this.valueType, this.parameters.withQueryType(RangeQueryParameters.QueryType.ALL_EDITS).withViewRange(RangeQueryParameters.DEFAULT_RANGE), Mode.VIEW_RANGE);
    }

    @Override
    public TimeSeries.RangeQuery<V> editRange() throws IllegalStateException {
        if (this.parameters.getQueryType() != RangeQueryParameters.QueryType.VALUES) {
            throw new IllegalStateException(".editRange() cannot be applied to this edit range query: " + String.valueOf(this));
        }
        return new RangeQueryImpl<V>(this.context, this.valueType, this.parameters, Mode.EDIT_RANGE);
    }

    @Override
    public TimeSeries.RangeQuery<V> allEdits() throws IllegalStateException {
        if (this.parameters.getQueryType() == RangeQueryParameters.QueryType.VALUES) {
            throw new IllegalStateException(".allEdits() cannot be applied to this value range query: " + String.valueOf(this));
        }
        return new RangeQueryImpl<V>(this.context, this.valueType, this.parameters.withQueryType(RangeQueryParameters.QueryType.ALL_EDITS), Mode.EDIT_RANGE);
    }

    @Override
    public TimeSeries.RangeQuery<V> latestEdits() throws IllegalStateException {
        if (this.parameters.getQueryType() == RangeQueryParameters.QueryType.VALUES) {
            throw new IllegalStateException(".latestEdits() cannot be applied to this value range query: " + String.valueOf(this));
        }
        return new RangeQueryImpl<V>(this.context, this.valueType, this.parameters.withQueryType(RangeQueryParameters.QueryType.LATEST_EDITS), Mode.EDIT_RANGE);
    }

    @Override
    public TimeSeries.RangeQuery<V> from(long sequence) {
        return this.withCurrentRange(r -> r.from(sequence));
    }

    @Override
    public TimeSeries.RangeQuery<V> fromStart() {
        return this.withCurrentRange(r -> r.fromStart());
    }

    @Override
    public TimeSeries.RangeQuery<V> from(Instant instant) {
        return this.withCurrentRange(r -> r.from(instant));
    }

    @Override
    public TimeSeries.RangeQuery<V> from(Date date) {
        return this.withCurrentRange(r -> r.from(date));
    }

    @Override
    public TimeSeries.RangeQuery<V> fromLast(long count) {
        return this.withCurrentRange(r -> r.fromLast(count));
    }

    @Override
    public TimeSeries.RangeQuery<V> fromLast(Duration timeSpan) {
        return this.withCurrentRange(r -> r.fromLast(timeSpan));
    }

    @Override
    public TimeSeries.RangeQuery<V> fromLastMillis(long timeSpan) {
        return this.withCurrentRange(r -> r.fromLastMillis(timeSpan));
    }

    @Override
    public TimeSeries.RangeQuery<V> to(long sequence) {
        return this.withCurrentRange(r -> r.to(sequence));
    }

    @Override
    public TimeSeries.RangeQuery<V> toStart() {
        return this.withCurrentRange(r -> r.toStart());
    }

    @Override
    public TimeSeries.RangeQuery<V> to(Instant instant) {
        return this.withCurrentRange(r -> r.to(instant));
    }

    @Override
    public TimeSeries.RangeQuery<V> to(Date date) {
        return this.withCurrentRange(r -> r.to(date));
    }

    @Override
    public TimeSeries.RangeQuery<V> untilLast(long count) {
        return this.withCurrentRange(r -> r.untilLast(count));
    }

    @Override
    public TimeSeries.RangeQuery<V> untilLast(Duration timeSpan) {
        return this.withCurrentRange(r -> r.untilLast(timeSpan));
    }

    @Override
    public TimeSeries.RangeQuery<V> untilLastMillis(long timeSpan) {
        return this.withCurrentRange(r -> r.untilLastMillis(timeSpan));
    }

    @Override
    public TimeSeries.RangeQuery<V> next(long count) {
        return this.withCurrentRange(r -> r.next(count));
    }

    @Override
    public TimeSeries.RangeQuery<V> next(Duration timeSpan) {
        return this.withCurrentRange(r -> r.next(timeSpan));
    }

    @Override
    public TimeSeries.RangeQuery<V> nextMillis(long timeSpan) {
        return this.withCurrentRange(r -> r.nextMillis(timeSpan));
    }

    @Override
    public TimeSeries.RangeQuery<V> previous(long count) {
        return this.withCurrentRange(r -> r.previous(count));
    }

    @Override
    public TimeSeries.RangeQuery<V> previous(Duration timeSpan) {
        return this.withCurrentRange(r -> r.previous(timeSpan));
    }

    @Override
    public TimeSeries.RangeQuery<V> previousMillis(long timeSpan) {
        return this.withCurrentRange(r -> r.previousMillis(timeSpan));
    }

    @Override
    public TimeSeries.RangeQuery<V> limit(long count) {
        return new RangeQueryImpl<V>(this.context, this.valueType, this.parameters.withLimit(count), this.mode);
    }

    @Override
    public <T> TimeSeries.RangeQuery<T> as(Class<T> newValueType) {
        return new RangeQueryImpl<T>(this.context, Objects.requireNonNull(newValueType, "valueType is null"), this.parameters, this.mode);
    }

    @Override
    public CompletableFuture<TimeSeries.QueryResult<V>> selectFrom(String topicPath) {
        RangeQueryRequest request = new RangeQueryRequest(Objects.requireNonNull(topicPath, "topicPath"), this.parameters);
        return this.context.service.sendCommand(request).thenApply(raw -> raw.createQueryResult(this.valueType, this.parameters.getQueryType().streamStructure()));
    }

    public int hashCode() {
        return this.parameters.hashCode();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof RangeQueryImpl && this.parameters.equals(((RangeQueryImpl)o).parameters);
    }

    public String toString() {
        return this.parameters.toString();
    }

    private RangeQueryImpl<V> withCurrentRange(UnaryOperator<RangeQueryParameters.Range> op) {
        return new RangeQueryImpl<V>(this.context, this.valueType, this.mode.changeCurrentRange(this.parameters, op), this.mode);
    }

    @Immutable
    private static final class Context {
        private final ServiceReference<RangeQueryRequest, RangeQueryResult> service;

        Context(ServiceReference<RangeQueryRequest, RangeQueryResult> service) {
            this.service = service;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Mode {
        VIEW_RANGE{

            @Override
            RangeQueryParameters changeCurrentRange(RangeQueryParameters original, UnaryOperator<RangeQueryParameters.Range> op) {
                return original.withViewRange((RangeQueryParameters.Range)op.apply(original.getViewRange()));
            }
        }
        ,
        EDIT_RANGE{

            @Override
            RangeQueryParameters changeCurrentRange(RangeQueryParameters original, UnaryOperator<RangeQueryParameters.Range> op) {
                return original.withEditRange((RangeQueryParameters.Range)op.apply(original.getEditRange()));
            }
        };


        abstract RangeQueryParameters changeCurrentRange(RangeQueryParameters var1, UnaryOperator<RangeQueryParameters.Range> var2);
    }
}

