/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.timeseries.event;

import com.pushtechnology.diffusion.client.features.TimeSeries;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.java7.Java7;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
public final class EventMetadataImpl
implements TimeSeries.EventMetadata {
    private final long sequence;
    private final long timestamp;
    private final String author;

    public static EventMetadataImpl readMetadata(InputStream in) throws IOException {
        long sequence = EncodedDataCodec.readInt64(in);
        long timestamp = EncodedDataCodec.readInt64(in);
        String author = EncodedDataCodec.readString(in);
        return new EventMetadataImpl(sequence, timestamp, author);
    }

    public static void writeMetadata(OutputStream out, TimeSeries.EventMetadata value) throws IOException {
        EncodedDataCodec.writeInt64(out, value.sequence());
        EncodedDataCodec.writeInt64(out, value.timestamp());
        EncodedDataCodec.writeString(out, value.author());
    }

    public EventMetadataImpl(long sequence, long timestamp, String author) {
        this.sequence = sequence;
        this.timestamp = timestamp;
        this.author = author;
    }

    @Override
    public long sequence() {
        return this.sequence;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public String author() {
        return this.author;
    }

    public int hashCode() {
        int result = Java7.longHashCode(this.sequence);
        result = 31 * result + Java7.longHashCode(this.timestamp);
        result = 31 * result + this.author.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventMetadataImpl)) {
            return false;
        }
        EventMetadataImpl other = (EventMetadataImpl)o;
        return EventMetadataImpl.equalMetadata(this, other);
    }

    static boolean equalMetadata(TimeSeries.EventMetadata m1, TimeSeries.EventMetadata m2) {
        return m1.sequence() == m2.sequence() && m1.timestamp() == m2.timestamp() && m1.author().equals(m2.author());
    }

    public String toString() {
        return "sequence=" + this.sequence + " timestamp=" + this.timestamp + " author=" + this.author;
    }
}

