/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.timeseries.event;

import com.pushtechnology.diffusion.client.features.TimeSeries;
import com.pushtechnology.diffusion.timeseries.event.EventMetadataImpl;
import net.jcip.annotations.Immutable;

@Immutable
public final class EventImpl<V>
implements TimeSeries.Event<V> {
    private final TimeSeries.EventMetadata metadata;
    private final TimeSeries.EventMetadata originalEvent;
    private final V value;

    public static <T> EventImpl<T> createEvent(TimeSeries.EventMetadata metadata, TimeSeries.EventMetadata originalEvent, T value) {
        return new EventImpl<T>(metadata, originalEvent.equals(metadata) ? metadata : originalEvent, value);
    }

    private EventImpl(TimeSeries.EventMetadata metadata, TimeSeries.EventMetadata originalEvent, V value) {
        this.metadata = metadata;
        this.originalEvent = originalEvent;
        this.value = value;
    }

    @Override
    public long sequence() {
        return this.metadata.sequence();
    }

    @Override
    public long timestamp() {
        return this.metadata.timestamp();
    }

    @Override
    public String author() {
        return this.metadata.author();
    }

    @Override
    public V value() {
        return this.value;
    }

    @Override
    public TimeSeries.EventMetadata originalEvent() {
        return this.isEditEvent() ? this.originalEvent : this;
    }

    @Override
    public boolean isEditEvent() {
        return this.metadata != this.originalEvent;
    }

    @Override
    public <T> EventImpl<T> withValue(T newValue) {
        return new EventImpl<T>(this.metadata, this.originalEvent, newValue);
    }

    public int hashCode() {
        int result = this.metadata.hashCode();
        result = 31 * result + this.originalEvent.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventImpl)) {
            return false;
        }
        EventImpl other = (EventImpl)o;
        return this.metadata.equals(other.metadata) && EventMetadataImpl.equalMetadata(this.originalEvent, other.originalEvent) && this.value.equals(other.value());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        if (this.isEditEvent()) {
            sb.append("Edit of [").append(this.originalEvent).append("] ");
        }
        sb.append('[').append(this.metadata.toString()).append("] ").append(this.value);
        return sb.toString();
    }
}

