/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.timeseries.datatype;

import com.pushtechnology.diffusion.client.features.TimeSeries;
import com.pushtechnology.diffusion.datatype.Bytes;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.datatype.InvalidDataException;
import com.pushtechnology.diffusion.datatype.internal.AbstractDataType;
import com.pushtechnology.diffusion.io.bytes.ArrayIBytes;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStream;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStreamImpl;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.timeseries.event.EventImpl;
import com.pushtechnology.diffusion.timeseries.event.EventMetadataImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.function.Function;
import net.jcip.annotations.Immutable;

@Immutable
public final class TimeSeriesEventDataType<V>
extends AbstractDataType<TimeSeries.Event<V>, ArrayIBytes> {
    private static final byte ORIGINAL_EVENT = 0;
    private static final byte EDIT_EVENT = 1;
    private final DataType<V> delegate;

    public static <V> TimeSeriesEventDataType<V> create(DataType<V> delegate) {
        return new TimeSeriesEventDataType<V>("timeseriesevent-" + delegate.getTypeName(), delegate);
    }

    public TimeSeriesEventDataType(String typeName, DataType<V> delegate) {
        super(typeName, TimeSeries.Event.class, ArrayIBytes.class, ArrayIBytes::toArrayIBytes, e -> TimeSeriesEventDataType.eventToBytes(delegate::toBytes, e), b -> TimeSeriesEventDataType.bytesToEvent(delegate::readValue, b), Collections.emptyMap(), true);
        this.delegate = delegate;
    }

    @Override
    public void writeValue(TimeSeries.Event<V> value, OutputStream out) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException(String.valueOf(this) + " cannot write null");
        }
        TimeSeriesEventDataType.writeValue(this.delegate::toBytes, value, out);
    }

    @Override
    public void validate(TimeSeries.Event<V> value) {
    }

    private static <V> ArrayIBytes eventToBytes(Function<V, Bytes> valueToBytes, TimeSeries.Event<V> event) {
        if (event == null) {
            throw new IllegalArgumentException("Cannot convert null event to Bytes");
        }
        IBytesOutputStreamImpl out = IBytesOutputStreamImpl.forThread();
        try {
            TimeSeriesEventDataType.writeValue(valueToBytes, event, out);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return ArrayIBytes.toArrayIBytes(((IBytesOutputStream)out).toIBytes());
    }

    private static <V> void writeValue(Function<V, Bytes> valueToBytes, TimeSeries.Event<V> event, OutputStream out) throws IOException {
        if (event.isEditEvent()) {
            EncodedDataCodec.writeByte(out, (byte)1);
            EventMetadataImpl.writeMetadata(out, event.originalEvent());
        } else {
            EncodedDataCodec.writeByte(out, (byte)0);
        }
        EventMetadataImpl.writeMetadata(out, event);
        Bytes serialisedValue = valueToBytes.apply(event.value());
        EncodedDataCodec.writeByteArray(out, IBytes.toByteArray(serialisedValue));
    }

    private static <V> TimeSeries.Event<V> bytesToEvent(Function<Bytes, V> bytesToValue, ArrayIBytes b) {
        ByteArrayInputStream in = new ByteArrayInputStream(b.bytes());
        try {
            byte eventType = EncodedDataCodec.readByte(in);
            switch (eventType) {
                case 0: {
                    return TimeSeriesEventDataType.readOriginalEvent(bytesToValue, in);
                }
                case 1: {
                    return TimeSeriesEventDataType.readEditEvent(bytesToValue, in);
                }
            }
            throw new InvalidDataException("Unrecognized event type: " + eventType);
        }
        catch (IOException e) {
            throw new InvalidDataException(e);
        }
    }

    public <T> boolean canReadEventValueAs(Class<T> otherValueClass) {
        return this.delegate.canReadAs(otherValueClass);
    }

    public <T> T readEventValueAs(Class<T> classOfT, TimeSeries.Event<V> event) {
        return this.delegate.readAs(classOfT, this.delegate.toBytes(event.value()));
    }

    private static <V> TimeSeries.Event<V> readOriginalEvent(Function<Bytes, V> bytesToValue, InputStream in) throws IOException {
        EventMetadataImpl metadata = EventMetadataImpl.readMetadata(in);
        V value = bytesToValue.apply(IBytes.toIBytes(EncodedDataCodec.readByteArray(in)));
        return EventImpl.createEvent(metadata, metadata, value);
    }

    private static <V> TimeSeries.Event<V> readEditEvent(Function<Bytes, V> bytesToValue, InputStream in) throws IOException {
        EventMetadataImpl originalEvent = EventMetadataImpl.readMetadata(in);
        EventMetadataImpl metadata = EventMetadataImpl.readMetadata(in);
        V value = bytesToValue.apply(IBytes.toIBytes(EncodedDataCodec.readByteArray(in)));
        return EventImpl.createEvent(metadata, originalEvent, value);
    }
}

