/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.statistics.metriccollectors;

import com.pushtechnology.diffusion.client.features.control.Metrics;
import com.pushtechnology.diffusion.statistics.metriccollectors.AbstractMetricCollector;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public final class TopicMetricCollectorImpl
extends AbstractMetricCollector
implements Metrics.TopicMetricCollector {
    private final String topicSelector;
    private final boolean groupByTopicType;
    private final int groupByPathPrefixParts;
    private final boolean groupByTopicView;

    public TopicMetricCollectorImpl(String name, boolean exportToPrometheus, int maximumGroups, String topicSelector, boolean groupByTopicType, int groupByPathPrefixParts, boolean groupByTopicView) throws IllegalArgumentException {
        super(name, exportToPrometheus, maximumGroups);
        this.groupByTopicView = groupByTopicView;
        if (groupByPathPrefixParts < 0) {
            throw new IllegalArgumentException("groupByPathPrefixParts must be non-negative: " + groupByPathPrefixParts);
        }
        this.topicSelector = topicSelector;
        this.groupByTopicType = groupByTopicType;
        this.groupByPathPrefixParts = groupByPathPrefixParts;
    }

    @Override
    public String getTopicSelector() {
        return this.topicSelector;
    }

    @Override
    public boolean groupsByTopicType() {
        return this.groupByTopicType;
    }

    @Override
    public boolean groupsByTopicView() {
        return this.groupByTopicView;
    }

    @Override
    public int groupByPathPrefixParts() {
        return this.groupByPathPrefixParts;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.topicSelector.hashCode();
        result = 31 * result + this.groupByPathPrefixParts;
        result = 31 * result + Boolean.hashCode(this.groupByTopicType);
        result = 31 * result + Boolean.hashCode(this.groupByTopicView);
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopicMetricCollectorImpl)) {
            return false;
        }
        TopicMetricCollectorImpl other = (TopicMetricCollectorImpl)o;
        return super.equalFields(other) && this.topicSelector.equals(other.topicSelector) && this.groupByPathPrefixParts == other.groupByPathPrefixParts && this.groupByTopicType == other.groupByTopicType && this.groupByTopicView == other.groupByTopicView;
    }

    @Override
    public String toString() {
        return super.toString() + ", topicSelector=" + this.topicSelector + ", groupByTopicType=" + this.groupByTopicType + ", groupByTopicView=" + this.groupByTopicView + ", groupByPathPrefixParts=" + this.groupByPathPrefixParts;
    }

    @Override
    public Map<String, Object> getJournableContext() {
        Map<String, Object> context = super.getJournableContext();
        context.put("type", "topic");
        context.put("selector", this.topicSelector);
        context.put("groupByTopicType", this.groupByTopicType);
        context.put("groupByPathPrefixParts", this.groupByPathPrefixParts);
        context.put("groupByTopicView", this.groupByTopicView);
        return context;
    }
}

