/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.statistics.metriccollectors;

import com.pushtechnology.diffusion.client.features.control.Metrics;
import com.pushtechnology.diffusion.client.topics.TopicSelectors;
import com.pushtechnology.diffusion.statistics.metriccollectors.TopicMetricCollectorImpl;
import java.util.Objects;

public final class TopicMetricCollectorBuilder
implements Metrics.TopicMetricCollector.Builder {
    private final TopicSelectors topicSelectors;
    private boolean exportToPrometheus = false;
    private int maximumGroups = Integer.MAX_VALUE;
    private boolean groupByTopicType = false;
    private int groupByPathPrefixParts = 0;
    private boolean groupByTopicView = false;

    public TopicMetricCollectorBuilder(TopicSelectors topicSelectors) {
        this.topicSelectors = topicSelectors;
    }

    @Override
    public Metrics.TopicMetricCollector.Builder exportToPrometheus(boolean export) {
        this.exportToPrometheus = export;
        return this;
    }

    @Override
    public Metrics.TopicMetricCollector.Builder maximumGroups(int limit) {
        this.maximumGroups = limit;
        return this;
    }

    @Override
    public Metrics.TopicMetricCollector.Builder groupByTopicType(boolean group) {
        this.groupByTopicType = group;
        return this;
    }

    @Override
    public Metrics.TopicMetricCollector.Builder groupByPathPrefixParts(int parts) {
        this.groupByPathPrefixParts = parts;
        return this;
    }

    @Override
    public Metrics.TopicMetricCollector.Builder groupByTopicView(boolean group) {
        this.groupByTopicView = group;
        return this;
    }

    @Override
    public Metrics.TopicMetricCollector.Builder reset() {
        this.exportToPrometheus = false;
        this.groupByTopicType = false;
        this.groupByPathPrefixParts = 0;
        return this;
    }

    @Override
    public Metrics.TopicMetricCollector create(String name, String topicSelector) {
        try {
            this.topicSelectors.parse(Objects.requireNonNull(topicSelector, "topicSelector is null"));
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("topicSelector is invalid", ex);
        }
        return new TopicMetricCollectorImpl(Objects.requireNonNull(name, "name is null"), this.exportToPrometheus, this.maximumGroups, topicSelector, this.groupByTopicType, this.groupByPathPrefixParts, this.groupByTopicView);
    }
}

