/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.statistics.metriccollectors;

import com.pushtechnology.diffusion.client.features.control.Metrics;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.statistics.metriccollectors.SessionMetricCollectorImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="session-metric-collector", valueType=Metrics.SessionMetricCollector.class)
public final class SessionMetricCollectorSerialiser
extends AbstractSerialiser<Metrics.SessionMetricCollector> {
    @Override
    public void write(OutputStream out, Metrics.SessionMetricCollector value) throws IOException {
        EncodedDataCodec.writeString(out, value.getName());
        EncodedDataCodec.writeBoolean(out, value.exportsToPrometheus());
        EncodedDataCodec.writeInt32(out, value.maximumGroups());
        EncodedDataCodec.writeBoolean(out, value.removesMetricsWithNoMatches());
        EncodedDataCodec.writeString(out, value.getSessionFilter());
        SessionMetricCollectorSerialiser.writeCollection(out, EncodedDataCodec::writeString, value.getGroupByProperties());
    }

    @Override
    protected Metrics.SessionMetricCollector readUnchecked(InputStream in) throws IOException {
        String name = EncodedDataCodec.readString(in);
        boolean exportToPrometheus = EncodedDataCodec.readBoolean(in);
        int maximumGroups = EncodedDataCodec.readInt32(in);
        boolean removeMetricsWithNoMatches = EncodedDataCodec.readBoolean(in);
        String sessionFilter = EncodedDataCodec.readString(in);
        List groupByProperties = SessionMetricCollectorSerialiser.readCollection(in, ArrayList::new, EncodedDataCodec::readString);
        return new SessionMetricCollectorImpl(name, exportToPrometheus, maximumGroups, removeMetricsWithNoMatches, sessionFilter, groupByProperties);
    }
}

