/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.statistics.metriccollectors;

import com.pushtechnology.diffusion.client.features.control.Metrics;
import com.pushtechnology.diffusion.statistics.metriccollectors.AbstractMetricCollector;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public final class SessionMetricCollectorImpl
extends AbstractMetricCollector
implements Metrics.SessionMetricCollector {
    private final String sessionFilter;
    private final List<String> groupByProperties;
    private final boolean removeMetricsWithNoMatches;

    public SessionMetricCollectorImpl(String name, boolean exportToPrometheus, int maximumGroups, boolean removeMetricsWithNoMatches, String sessionFilter, List<String> groupByProperties) {
        super(name, exportToPrometheus, maximumGroups);
        this.removeMetricsWithNoMatches = removeMetricsWithNoMatches;
        this.sessionFilter = sessionFilter;
        this.groupByProperties = Collections.unmodifiableList(groupByProperties);
    }

    @Override
    public boolean removesMetricsWithNoMatches() {
        return this.removeMetricsWithNoMatches;
    }

    @Override
    public String getSessionFilter() {
        return this.sessionFilter;
    }

    @Override
    public List<String> getGroupByProperties() {
        return this.groupByProperties;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Boolean.hashCode(this.removeMetricsWithNoMatches);
        result = result * 31 + this.sessionFilter.hashCode();
        result = result * 31 + this.groupByProperties.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SessionMetricCollectorImpl)) {
            return false;
        }
        SessionMetricCollectorImpl other = (SessionMetricCollectorImpl)o;
        return super.equalFields(other) && this.sessionFilter.equals(other.sessionFilter) && this.groupByProperties.equals(other.groupByProperties) && this.removeMetricsWithNoMatches == other.removeMetricsWithNoMatches;
    }

    @Override
    public String toString() {
        return super.toString() + ", removeMetricsWithNoMatches=" + this.removeMetricsWithNoMatches + ", sessionFilter=" + this.sessionFilter + ", groupByProperties=" + String.valueOf(this.groupByProperties);
    }

    @Override
    public Map<String, Object> getJournableContext() {
        Map<String, Object> context = super.getJournableContext();
        context.put("type", "session");
        context.put("filter", this.sessionFilter);
        context.put("groupByProperties", this.groupByProperties);
        context.put("removeMetricsWithNoMatches", this.removeMetricsWithNoMatches);
        return context;
    }
}

