/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.statistics.metriccollectors;

import com.pushtechnology.diffusion.client.features.control.Metrics;
import com.pushtechnology.diffusion.journal.Journable;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public abstract class AbstractMetricCollector
implements Metrics.MetricCollector,
Journable {
    private final String name;
    private final boolean exportToPrometheus;
    private final int maximumGroups;

    protected AbstractMetricCollector(String name, boolean exportToPrometheus, int maximumGroups) {
        if (name.length() == 0) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        if (maximumGroups < 1) {
            throw new IllegalArgumentException("maximumGroups must be positive: " + maximumGroups);
        }
        this.name = name;
        this.exportToPrometheus = exportToPrometheus;
        this.maximumGroups = maximumGroups;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final boolean exportsToPrometheus() {
        return this.exportToPrometheus;
    }

    @Override
    public final int maximumGroups() {
        return this.maximumGroups;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.maximumGroups;
        result = 31 * result + Boolean.hashCode(this.exportToPrometheus);
        return result;
    }

    protected final boolean equalFields(AbstractMetricCollector o) {
        return this.name.equals(o.name) && this.maximumGroups == o.maximumGroups && this.exportToPrometheus == o.exportToPrometheus;
    }

    public String toString() {
        return "name=\"" + this.name + "\", exportToPrometheus=" + this.exportToPrometheus + " maximumGroups=" + this.maximumGroups;
    }

    @Override
    public Map<String, Object> getJournableContext() {
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>(8);
        context.put("name", this.name);
        context.put("prometheus", this.exportToPrometheus);
        context.put("maximumGroups", this.maximumGroups);
        return context;
    }
}

