/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.statistics;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.statistics.SerializableMetricsRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.regex.Pattern;

@CommandSerialiser(spec="protocol26-metrics-request", valueType=SerializableMetricsRequest.class)
public final class Protocol26MetricsRequestSerialiser
extends AbstractSerialiser<SerializableMetricsRequest> {
    @Override
    public void write(OutputStream out, SerializableMetricsRequest value) throws IOException {
        Protocol26MetricsRequestSerialiser.writeStrings(out, value.getFilters());
        if (value.getPatternFilter() == null) {
            EncodedDataCodec.writeString(out, "");
        } else {
            EncodedDataCodec.writeString(out, value.getPatternFilter().pattern());
        }
        EncodedDataCodec.writeByte(out, value.requestType().toByte());
        if (value.requestType() == SerializableMetricsRequest.RequestType.NAMED_SERVER) {
            EncodedDataCodec.writeString(out, value.getServer());
        }
    }

    @Override
    protected SerializableMetricsRequest readUnchecked(InputStream in) throws IOException {
        HashSet<String> filters = new HashSet<String>(Protocol26MetricsRequestSerialiser.readStrings(in));
        String filterRegex = EncodedDataCodec.readString(in);
        SerializableMetricsRequest.RequestType requestType = SerializableMetricsRequest.RequestType.fromByte(EncodedDataCodec.readByte(in));
        String server = requestType == SerializableMetricsRequest.RequestType.NAMED_SERVER ? EncodedDataCodec.readString(in) : null;
        Pattern patternFilter = filterRegex.isEmpty() ? null : Pattern.compile(filterRegex);
        return new SerializableMetricsRequest(filters, patternFilter, server, requestType);
    }
}

