/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.statistics;

import com.pushtechnology.diffusion.client.features.control.Metrics;
import com.pushtechnology.diffusion.client.types.serialisation.EnumConverter;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.statistics.MetricSampleCollectionImpl;
import com.pushtechnology.diffusion.statistics.Protocol26MetricSampleSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

@CommandSerialiser(spec="protocol26-metrics-sample-collection", valueType=Metrics.MetricSampleCollection.class)
public final class Protocol26MetricSamplesCollectionSerialiser
extends AbstractSerialiser<Metrics.MetricSampleCollection> {
    private static final EnumConverter<Metrics.MetricType> CONVERTER = new EnumConverter.Builder<Metrics.MetricType>(Metrics.MetricType.class).bimap(0, Metrics.MetricType.COUNTER).bimap(1, Metrics.MetricType.GAUGE).bimap(2, Metrics.MetricType.INFO).bimap(3, Metrics.MetricType.HISTOGRAM).bimap(4, Metrics.MetricType.GAUGE_HISTOGRAM).bimap(5, Metrics.MetricType.STATE_SET).bimap(6, Metrics.MetricType.SUMMARY).bimap(7, Metrics.MetricType.UNKNOWN).build();
    private final Protocol26MetricSampleSerialiser metricSampleSerialiser;

    public Protocol26MetricSamplesCollectionSerialiser(Protocol26MetricSampleSerialiser sampleSerialiser) {
        this.metricSampleSerialiser = sampleSerialiser;
    }

    @Override
    public void write(OutputStream out, Metrics.MetricSampleCollection sampleCollection) throws IOException {
        EncodedDataCodec.writeString(out, sampleCollection.getName());
        EncodedDataCodec.writeString(out, sampleCollection.getUnit());
        EncodedDataCodec.writeByte(out, CONVERTER.toByte(sampleCollection.getType()));
        Protocol26MetricSamplesCollectionSerialiser.writeCollection(out, this.metricSampleSerialiser, sampleCollection.getSamples());
    }

    @Override
    protected Metrics.MetricSampleCollection readUnchecked(InputStream in) throws IOException {
        String name = EncodedDataCodec.readString(in);
        String unit = EncodedDataCodec.readString(in);
        Metrics.MetricType type = CONVERTER.fromByte(EncodedDataCodec.readByte(in));
        List samples = Protocol26MetricSamplesCollectionSerialiser.readCollection(in, ArrayList::new, this.metricSampleSerialiser);
        return new MetricSampleCollectionImpl(name, unit, type, samples);
    }
}

