/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.statistics;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.statistics.MeasuredEntityClassMetricsRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@CommandSerialiser(spec="protocol21-measured-entity-class-request", valueType=MeasuredEntityClassMetricsRequest.class)
public final class Protocol21MeasuredEntityClassMetricsRequestSerialiser
extends AbstractSerialiser<MeasuredEntityClassMetricsRequest> {
    @Override
    public void write(OutputStream out, MeasuredEntityClassMetricsRequest value) throws IOException {
        EncodedDataCodec.writeString(out, value.getMetricsClass());
        if (value.getServerName() != null) {
            EncodedDataCodec.writeByte(out, (byte)1);
            EncodedDataCodec.writeString(out, value.getServerName());
        } else {
            EncodedDataCodec.writeByte(out, (byte)0);
        }
    }

    @Override
    protected MeasuredEntityClassMetricsRequest readUnchecked(InputStream in) throws IOException {
        String entityClass = EncodedDataCodec.readString(in);
        String serverName = EncodedDataCodec.readByte(in) > 0 ? EncodedDataCodec.readString(in) : null;
        return new MeasuredEntityClassMetricsRequest(entityClass, serverName);
    }
}

