/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.statistics;

import com.pushtechnology.diffusion.client.features.control.Metrics;
import com.pushtechnology.diffusion.statistics.MetricSampleCollectionList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public final class MetricsResultImpl
implements Metrics.MetricsResult {
    private final Map<String, MetricSampleCollectionList> sampleCollections;

    public MetricsResultImpl(Map<String, MetricSampleCollectionList> sampleCollections) {
        this.sampleCollections = sampleCollections;
    }

    @Override
    public Set<String> getServerNames() {
        return this.sampleCollections.keySet();
    }

    @Override
    public List<Metrics.MetricSampleCollection> getMetrics(String serverName) {
        Objects.requireNonNull(serverName, "serverName must not be null");
        return this.sampleCollections.get(serverName).getSampleCollections();
    }

    public Map<String, MetricSampleCollectionList> samplesByServer() {
        return Collections.unmodifiableMap(this.sampleCollections);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricsResultImpl that = (MetricsResultImpl)o;
        return Objects.equals(this.sampleCollections, that.sampleCollections);
    }

    public int hashCode() {
        return Objects.hash(this.sampleCollections);
    }

    public String toString() {
        return "MetricsResult[sampleCollections=" + String.valueOf(this.sampleCollections) + "]";
    }
}

