/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.statistics;

import com.pushtechnology.diffusion.client.features.control.Metrics;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.jcip.annotations.Immutable;

@Immutable
public final class MetricSampleImpl
implements Metrics.MetricSample {
    private final String name;
    private final List<String> labelNames;
    private final List<String> labelValues;
    private final Long timestamp;
    private final double value;

    public MetricSampleImpl(String name, List<String> labelNames, List<String> labelValues, Long timestamp, double value) {
        this.name = name;
        this.labelNames = labelNames;
        this.labelValues = labelValues;
        this.timestamp = timestamp;
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getLabelNames() {
        return Collections.unmodifiableList(this.labelNames);
    }

    @Override
    public List<String> getLabelValues() {
        return Collections.unmodifiableList(this.labelValues);
    }

    @Override
    public Optional<Long> getTimestamp() {
        return Optional.ofNullable(this.timestamp);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricSampleImpl that = (MetricSampleImpl)o;
        return Double.compare(that.value, this.value) == 0 && this.name.equals(that.name) && this.labelNames.equals(that.labelNames) && this.labelValues.equals(that.labelValues) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.labelNames, this.labelValues, this.timestamp, this.value);
    }

    public String toString() {
        return "MetricSample [name='" + this.name + "', labelNames=" + String.valueOf(this.labelNames) + ", labelValues=" + String.valueOf(this.labelValues) + ", timestamp=" + this.timestamp + ", value=" + this.value + "]";
    }
}

