/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.statistics;

import com.pushtechnology.diffusion.client.features.control.Metrics;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class MetricSampleCollectionImpl
implements Metrics.MetricSampleCollection {
    private final String name;
    private final String unit;
    private final Metrics.MetricType type;
    private final List<Metrics.MetricSample> samples;

    public MetricSampleCollectionImpl(String name, String unit, Metrics.MetricType type, List<Metrics.MetricSample> samples) {
        this.name = name;
        this.unit = unit;
        this.type = type;
        this.samples = samples;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Metrics.MetricType getType() {
        return this.type;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public List<Metrics.MetricSample> getSamples() {
        return Collections.unmodifiableList(this.samples);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricSampleCollectionImpl that = (MetricSampleCollectionImpl)o;
        return this.name.equals(that.name) && Objects.equals(this.unit, that.unit) && this.type == that.type && this.samples.equals(that.samples);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.unit, this.type, this.samples});
    }

    public String toString() {
        return "MetricSampleCollection [name='" + this.name + "', unit='" + this.unit + "', type=" + String.valueOf((Object)this.type) + ", samples=" + String.valueOf(this.samples) + "]";
    }
}

