/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.statistics;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.statistics.LongValuesMap;
import com.pushtechnology.diffusion.statistics.MeasuredEntityClassMetrics;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

@CommandSerialiser(spec="measured-entity-class-metrics", valueType=MeasuredEntityClassMetrics.class)
public final class MeasuredEntityClassMetricsSerialiser
extends AbstractSerialiser<MeasuredEntityClassMetrics> {
    @Override
    public void write(OutputStream out, MeasuredEntityClassMetrics value) throws IOException {
        MeasuredEntityClassMetricsSerialiser.writeStrings(out, value.getMetricNames());
        MeasuredEntityClassMetricsSerialiser.writeMap(out, (x$0, x$1) -> AbstractSerialiser.writeStrings(x$0, x$1), MeasuredEntityClassMetricsSerialiser::writeDimensionValuesToMetricValues, value.getValues());
    }

    private static void writeDimensionValuesToMetricValues(OutputStream out, LongValuesMap<List<String>> dimensionValuesToMetricValues) throws IOException {
        MeasuredEntityClassMetricsSerialiser.writeMap(out, (x$0, x$1) -> AbstractSerialiser.writeStrings(x$0, x$1), MeasuredEntityClassMetricsSerialiser::writeMetricValues, dimensionValuesToMetricValues);
    }

    private static void writeMetricValues(OutputStream out, long[] values) throws IOException {
        EncodedDataCodec.writeInt32(out, values.length);
        for (long v : values) {
            EncodedDataCodec.writeInt64(out, v);
        }
    }

    @Override
    protected MeasuredEntityClassMetrics readUnchecked(InputStream in) throws IOException {
        return new MeasuredEntityClassMetrics(MeasuredEntityClassMetricsSerialiser.readStrings(in), MeasuredEntityClassMetricsSerialiser.readMap(in, x$0 -> AbstractSerialiser.readStrings(x$0), MeasuredEntityClassMetricsSerialiser::readDimensionValuesToMetricValues));
    }

    private static LongValuesMap<List<String>> readDimensionValuesToMetricValues(InputStream in) throws IOException {
        return MeasuredEntityClassMetricsSerialiser.readMap(in, x$0 -> AbstractSerialiser.readStrings(x$0), MeasuredEntityClassMetricsSerialiser::readMetricValues, LongValuesMap::new);
    }

    private static long[] readMetricValues(InputStream in) throws IOException {
        int n = EncodedDataCodec.readInt32(in);
        long[] values = new long[n];
        for (int i = 0; i < n; ++i) {
            values[i] = EncodedDataCodec.readInt64(in);
        }
        return values;
    }
}

