/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.session.impl;

import com.pushtechnology.diffusion.client.session.SessionId;
import com.pushtechnology.diffusion.session.impl.InternalSessionId;
import com.pushtechnology.diffusion.utils.CharsetUtils;
import net.jcip.annotations.Immutable;

@Immutable
public final class SessionIdImpl
implements InternalSessionId,
Comparable<SessionIdImpl> {
    private final long serverInstance;
    private final long value;

    public SessionIdImpl(long serverInstance, long value) {
        this.serverInstance = serverInstance;
        this.value = value;
    }

    @Override
    public int hashCode() {
        return 31 * Long.hashCode(this.serverInstance) + Long.hashCode(this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionIdImpl other = (SessionIdImpl)o;
        return this.value == other.value && this.serverInstance == other.serverInstance;
    }

    @Override
    public String toString() {
        char[] chars = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '-', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};
        SessionIdImpl.setHex(chars, 0, this.serverInstance);
        SessionIdImpl.setHex(chars, 17, this.value);
        return new String(chars);
    }

    private static void setHex(char[] chars, int start, long l) {
        String s = Long.toHexString(l);
        int offset = start + 16 - s.length();
        for (int i = s.length() - 1; i >= 0; --i) {
            chars[offset + i] = s.charAt(i);
        }
    }

    @Override
    public long getServerInstance() {
        return this.serverInstance;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    public static InternalSessionId parseString(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Session Id is null");
        }
        int separator = s.indexOf(45);
        try {
            long server = SessionIdImpl.parseUnsignedLong(s.substring(0, separator));
            long value = SessionIdImpl.parseUnsignedLong(s.substring(separator + 1));
            return new SessionIdImpl(server, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Unknown format: " + s);
        }
    }

    public static InternalSessionId parseASCII(byte[] b) {
        return SessionIdImpl.parseString(CharsetUtils.asciiToString(b));
    }

    private static long parseUnsignedLong(String s) {
        Long high = Long.parseLong(s.substring(0, 8), 16);
        Long low = Long.parseLong(s.substring(8), 16);
        return (high << 32) + low;
    }

    public boolean sameServer(SessionId other) {
        return this.serverInstance >>> 32 == ((SessionIdImpl)other).serverInstance >>> 32;
    }

    public boolean sameServerInstance(SessionId other) {
        return this.serverInstance == ((SessionIdImpl)other).serverInstance;
    }

    @Override
    public int compareTo(SessionIdImpl o) {
        if (this == o) {
            return 0;
        }
        SessionIdImpl i = o;
        if (this.serverInstance > i.serverInstance) {
            return 1;
        }
        if (this.serverInstance < i.serverInstance) {
            return -1;
        }
        if (this.value > i.value) {
            return 1;
        }
        if (this.value < i.value) {
            return -1;
        }
        return 0;
    }
}

