/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.servers;

import com.pushtechnology.diffusion.client.features.control.RemoteServers;
import com.pushtechnology.diffusion.journal.Journable;
import com.pushtechnology.diffusion.servers.RemoteServerDefinition;
import com.pushtechnology.diffusion.servers.RemoteServerDefinitionImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class RemoteServerImpl
implements RemoteServers.PrimaryInitiator,
RemoteServers.SecondaryAcceptor,
RemoteServers.SecondaryInitiator,
Journable {
    private final RemoteServers.RemoteServer.Type theType;
    private final String theName;
    private final List<String> theUrls;
    private final String thePrincipal;
    private final Map<RemoteServers.RemoteServer.ConnectionOption, String> theConnectionOptions;
    private final String theMissingTopicNotificationFilter;
    private final String theConnector;

    static RemoteServerImpl createPrimary(String name, List<String> urls, int retryDelay, String connector) {
        return new RemoteServerImpl(RemoteServers.RemoteServer.Type.PRIMARY_INITIATOR, name, urls, "", Collections.singletonMap(RemoteServers.RemoteServer.ConnectionOption.RETRY_DELAY, Integer.toString(retryDelay)), null, connector);
    }

    static RemoteServerImpl createSecondary(RemoteServers.RemoteServer.Type type, String name, String url, String principal, Map<RemoteServers.RemoteServer.ConnectionOption, String> connectionOptions, String missingTopicNotificationFilter) {
        return new RemoteServerImpl(type, name, Arrays.asList(url), principal, connectionOptions, missingTopicNotificationFilter, null);
    }

    static RemoteServerImpl create(RemoteServerDefinition from) {
        RemoteServerDefinitionImpl impl = (RemoteServerDefinitionImpl)from;
        return new RemoteServerImpl(impl.getType(), impl.getName(), impl.getUrls(), impl.getPrincipal(), impl.getConnectionOptions(), impl.getMissingTopicNotificationFilter(), impl.getConnector());
    }

    RemoteServerImpl(RemoteServers.RemoteServer.Type type, String name, List<String> urls, String principal, Map<RemoteServers.RemoteServer.ConnectionOption, String> connectionOptions, String missingTopicNotificationFilter, String connector) {
        this.theType = type;
        this.theName = name;
        this.theUrls = urls == null ? null : Collections.unmodifiableList(urls);
        this.thePrincipal = principal;
        this.theConnectionOptions = connectionOptions == null ? null : Collections.unmodifiableMap(connectionOptions);
        this.theMissingTopicNotificationFilter = missingTopicNotificationFilter;
        this.theConnector = connector;
    }

    @Override
    public final RemoteServers.RemoteServer.Type getType() {
        return this.theType;
    }

    @Override
    public final String getName() {
        return this.theName;
    }

    @Override
    public final String getUrl() {
        return this.theUrls.get(0);
    }

    @Override
    public final String getPrimaryHostName() {
        return this.theUrls.get(0);
    }

    @Override
    public final List<String> getUrls() {
        return this.theUrls;
    }

    @Override
    public final String getPrincipal() {
        return this.thePrincipal;
    }

    @Override
    public final Map<RemoteServers.RemoteServer.ConnectionOption, String> getConnectionOptions() {
        return this.theConnectionOptions;
    }

    @Override
    public final int getRetryDelay() {
        String retryDelay = this.theConnectionOptions.get((Object)RemoteServers.RemoteServer.ConnectionOption.RETRY_DELAY);
        return retryDelay == null ? 1000 : Integer.parseInt(retryDelay);
    }

    @Override
    public final String getMissingTopicNotificationFilter() {
        return this.theMissingTopicNotificationFilter;
    }

    @Override
    public final String getConnector() {
        return this.theConnector;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.theType, this.theName, this.theUrls, this.thePrincipal, this.theConnectionOptions, this.theMissingTopicNotificationFilter, this.theConnector});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RemoteServerImpl)) {
            return false;
        }
        RemoteServerImpl other = (RemoteServerImpl)obj;
        return this.theType == other.theType && this.theName.equals(other.theName) && Objects.equals(this.theUrls, other.theUrls) && Objects.equals(this.thePrincipal, other.thePrincipal) && Objects.equals(this.theConnectionOptions, other.theConnectionOptions) && Objects.equals(this.theMissingTopicNotificationFilter, other.theMissingTopicNotificationFilter) && Objects.equals(this.theConnector, other.theConnector);
    }

    public final String toString() {
        if (this.theType == RemoteServers.RemoteServer.Type.PRIMARY_INITIATOR) {
            return String.valueOf((Object)this.theType) + " [Name=" + this.theName + ", URLs=" + String.valueOf(this.theUrls) + ", Connector=" + this.theConnector + ", Retry Delay=" + this.getRetryDelay() + "]";
        }
        if (this.theType == RemoteServers.RemoteServer.Type.SECONDARY_ACCEPTOR) {
            return String.valueOf((Object)this.theType) + " [Name=" + this.theName + ", Host Name=" + (this.theUrls.isEmpty() ? null : this.theUrls.get(0)) + ", Principal=" + this.thePrincipal + ", Connection Options=" + String.valueOf(this.theConnectionOptions) + ", Missing Topic Notification Filter=" + this.theMissingTopicNotificationFilter + "]";
        }
        return String.valueOf((Object)this.theType) + " [Name=" + this.theName + ", URL=" + (this.theUrls.isEmpty() ? null : this.theUrls.get(0)) + ", Principal=" + this.thePrincipal + ", Connection Options=" + String.valueOf(this.theConnectionOptions) + ", Missing Topic Notification Filter=" + this.theMissingTopicNotificationFilter + "]";
    }

    @Override
    public Map<String, Object> getJournableContext() {
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>(6);
        context.put("name", this.theName);
        context.put("type", (Object)this.theType);
        if (this.theType == RemoteServers.RemoteServer.Type.PRIMARY_INITIATOR) {
            context.put("urls", this.theUrls);
            context.put("connector", this.theConnector);
            context.put("retryDelay", this.getRetryDelay());
        } else {
            if (!this.theUrls.isEmpty()) {
                context.put("host", this.theUrls.get(0));
            }
            context.put("principal", this.thePrincipal);
            if (this.theConnectionOptions != null && !this.theConnectionOptions.isEmpty()) {
                context.put("connectionOptions", this.theConnectionOptions);
            }
            if (this.theMissingTopicNotificationFilter != null) {
                context.put("missingTopicNotificationFilter", this.theMissingTopicNotificationFilter);
            }
        }
        return context;
    }
}

