/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.servers;

import com.pushtechnology.diffusion.client.features.control.RemoteServers;
import com.pushtechnology.diffusion.client.types.Credentials;
import com.pushtechnology.diffusion.client.types.impl.CredentialsImpl;
import com.pushtechnology.diffusion.servers.RemoteServerDefinition;
import com.pushtechnology.diffusion.servers.RemoteServerImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class RemoteServerDefinitionImpl
extends RemoteServerImpl
implements RemoteServerDefinition {
    private final Credentials theCredentials;

    public static RemoteServerDefinitionImpl createPrimaryDefinition(String name, List<String> urls, int retryDelay, String connector) {
        return new RemoteServerDefinitionImpl(RemoteServers.RemoteServer.Type.PRIMARY_INITIATOR, name, urls, "", Collections.singletonMap(RemoteServers.RemoteServer.ConnectionOption.RETRY_DELAY, Integer.toString(retryDelay)), null, connector, CredentialsImpl.NO_CREDENTIALS);
    }

    public static RemoteServerDefinitionImpl createSecondaryDefinition(RemoteServers.RemoteServer.Type type, String name, String url, String principal, Map<RemoteServers.RemoteServer.ConnectionOption, String> connectionOptions, String missingTopicNotificationFilter, Credentials credentials) {
        return new RemoteServerDefinitionImpl(type, name, Collections.singletonList(url), principal, connectionOptions, missingTopicNotificationFilter, null, credentials);
    }

    public static RemoteServerDefinitionImpl createDefinition(RemoteServerImpl remoteServer, Credentials credentials) {
        return new RemoteServerDefinitionImpl(remoteServer.getType(), remoteServer.getName(), remoteServer.getUrls(), remoteServer.getPrincipal(), remoteServer.getConnectionOptions(), remoteServer.getMissingTopicNotificationFilter(), remoteServer.getConnector(), credentials);
    }

    private RemoteServerDefinitionImpl(RemoteServers.RemoteServer.Type type, String name, List<String> urls, String principal, Map<RemoteServers.RemoteServer.ConnectionOption, String> connectionOptions, String missingTopicNotificationFilter, String connector, Credentials credentials) {
        super(type, name, urls, principal, connectionOptions, missingTopicNotificationFilter, connector);
        this.theCredentials = credentials;
    }

    @Override
    public Credentials getCredentials() {
        return this.theCredentials;
    }

    @Override
    public RemoteServerDefinition withOptions(Map<RemoteServers.RemoteServer.ConnectionOption, String> options) {
        return new RemoteServerDefinitionImpl(this.getType(), this.getName(), this.getUrls(), this.getPrincipal(), options, this.getMissingTopicNotificationFilter(), this.getConnector(), this.getCredentials());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.theCredentials);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteServerDefinitionImpl other = (RemoteServerDefinitionImpl)obj;
        return super.equals(other) && Objects.equals(this.theCredentials, other.theCredentials);
    }
}

