/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.servers;

import com.pushtechnology.diffusion.client.features.control.RemoteServers;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.servers.AbstractRemoteServerSerialiser;
import com.pushtechnology.diffusion.servers.RemoteServerConnectionOptionConverter;
import com.pushtechnology.diffusion.servers.RemoteServerImpl;
import com.pushtechnology.diffusion.servers.RemoteServerTypeConvertor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

@CommandSerialiser(spec="protocol25-remote-server", valueType=RemoteServers.RemoteServer.class)
public final class Protocol25RemoteServerSerialiser
extends AbstractRemoteServerSerialiser {
    @Override
    public void write(OutputStream out, RemoteServers.RemoteServer server) throws IOException {
        RemoteServerImpl impl = (RemoteServerImpl)server;
        EncodedDataCodec.writeByte(out, RemoteServerTypeConvertor.toByte(impl.getType()));
        EncodedDataCodec.writeString(out, impl.getName());
        Protocol25RemoteServerSerialiser.writeStrings(out, impl.getUrls());
        EncodedDataCodec.writeString(out, impl.getPrincipal());
        Protocol25RemoteServerSerialiser.writeMap(out, (o, v) -> EncodedDataCodec.writeByte(out, RemoteServerConnectionOptionConverter.toByte(v)), (o, v) -> EncodedDataCodec.writeString(out, v), impl.getConnectionOptions());
        String filter = impl.getMissingTopicNotificationFilter();
        if (filter == null) {
            EncodedDataCodec.writeString(out, "");
        } else {
            EncodedDataCodec.writeString(out, filter);
        }
        String connector = impl.getConnector();
        if (connector == null) {
            EncodedDataCodec.writeString(out, "");
        } else {
            EncodedDataCodec.writeString(out, connector);
        }
    }

    @Override
    protected RemoteServers.RemoteServer readUnchecked(InputStream in) throws IOException {
        RemoteServers.RemoteServer.Type type = RemoteServerTypeConvertor.fromByte(EncodedDataCodec.readByte(in));
        String name = EncodedDataCodec.readString(in);
        List<String> urls = Protocol25RemoteServerSerialiser.readStrings(in);
        String principal = EncodedDataCodec.readString(in);
        Map<RemoteServers.RemoteServer.ConnectionOption, String> options = Protocol25RemoteServerSerialiser.readMap(in, i -> RemoteServerConnectionOptionConverter.fromByte(EncodedDataCodec.readByte(in)), i -> EncodedDataCodec.readString(in));
        String mtnFilter = EncodedDataCodec.readString(in);
        String connector = EncodedDataCodec.readString(in);
        return new RemoteServerImpl(type, name, urls, principal, options, mtnFilter.isEmpty() ? null : mtnFilter, connector.isEmpty() ? null : connector);
    }
}

