/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.servers;

import com.pushtechnology.diffusion.client.features.control.RemoteServers;
import com.pushtechnology.diffusion.client.types.serialisation.EnumConverter;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.servers.CheckRemoteServerResultImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@CommandSerialiser(spec="check-remote-server-result", valueType=RemoteServers.CheckRemoteServerResult.class)
public final class CheckRemoteServerResultSerialiser
extends AbstractSerialiser<RemoteServers.CheckRemoteServerResult> {
    private static final EnumConverter<RemoteServers.CheckRemoteServerResult.ConnectionState> CONNECTION_STATE_CONVERTER = new EnumConverter.Builder<RemoteServers.CheckRemoteServerResult.ConnectionState>(RemoteServers.CheckRemoteServerResult.ConnectionState.class).bimap(1, RemoteServers.CheckRemoteServerResult.ConnectionState.INACTIVE).bimap(2, RemoteServers.CheckRemoteServerResult.ConnectionState.CONNECTED).bimap(3, RemoteServers.CheckRemoteServerResult.ConnectionState.RETRYING).bimap(4, RemoteServers.CheckRemoteServerResult.ConnectionState.FAILED).bimap(5, RemoteServers.CheckRemoteServerResult.ConnectionState.MISSING).build();

    @Override
    public void write(OutputStream out, RemoteServers.CheckRemoteServerResult result) throws IOException {
        EncodedDataCodec.writeByte(out, CONNECTION_STATE_CONVERTER.toByte(result.getConnectionState()));
        EncodedDataCodec.writeString(out, result.getFailureMessage());
    }

    @Override
    protected RemoteServers.CheckRemoteServerResult readUnchecked(InputStream in) throws IOException {
        return new CheckRemoteServerResultImpl(CONNECTION_STATE_CONVERTER.fromByte(EncodedDataCodec.readByte(in)), EncodedDataCodec.readString(in));
    }
}

